/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import de.viaboxx.nlstools.model.MBEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="bundle")
public class MBBundle
implements Cloneable {
    @XStreamAsAttribute
    private String baseName;
    @XStreamAsAttribute
    private String interfaceName;
    @XStreamAsAttribute
    private String sqldomain;
    @XStreamImplicit
    private List<MBEntry> entries = new ArrayList<MBEntry>();

    public void sort() {
        if (this.entries != null) {
            Collections.sort(this.entries);
        }
        for (MBEntry each : this.getEntries()) {
            each.sort();
        }
    }

    public List<MBEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<MBEntry>();
        }
        return this.entries;
    }

    public void setEntries(List<MBEntry> entries) {
        this.entries = entries;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getSqldomain() {
        return this.sqldomain;
    }

    public void setSqldomain(String sqldomain) {
        this.sqldomain = sqldomain;
    }

    public MBEntry getEntry(String key) {
        for (MBEntry each : this.entries) {
            if ((key != null || each.getKey() != null) && (key == null || !key.equals(each.getKey()))) continue;
            return each;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MBBundle mbBundle = (MBBundle)o;
        return !((this.baseName == null ? mbBundle.baseName != null : !this.baseName.equals(mbBundle.baseName)) || (this.entries == null ? mbBundle.entries != null : !this.entries.equals(mbBundle.entries)) || (this.interfaceName == null ? mbBundle.interfaceName != null : !this.interfaceName.equals(mbBundle.interfaceName)) || (this.sqldomain == null ? mbBundle.sqldomain != null : !this.sqldomain.equals(mbBundle.sqldomain)));
    }

    public MBBundle copy() {
        try {
            MBBundle copy = (MBBundle)this.clone();
            copy.setEntries(new ArrayList<MBEntry>(this.getEntries().size()));
            for (MBEntry entry : this.getEntries()) {
                copy.getEntries().add(entry.copy());
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void removeEntries() {
        this.getEntries().clear();
    }
}

