/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.io.json.JsonHierarchicalStreamDriver;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.formats.MBXMLPersistencer;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;

public class MBJSONPersistencer
extends MBPersistencer {
    static final XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
    static final XStream xstream_pretty;
    private boolean pretty;

    public MBJSONPersistencer(boolean pretty) {
        this.pretty = pretty;
    }

    public void save(MBBundles object, File file) throws Exception {
        this.mkdirs(file);
        this.saveObject(object, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveObject(Object obj, File target) throws Exception {
        Writer out = FileUtils.openFileWriterUTF8(target);
        try {
            if (this.pretty) {
                xstream_pretty.toXML(obj, out);
            } else {
                xstream.toXML(obj, out);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBBundles load(File source) throws IOException, ClassNotFoundException {
        Reader reader = FileUtils.openFileReaderUTF8(source);
        try {
            MBBundles mBBundles = this.load(reader);
            return mBBundles;
        }
        finally {
            reader.close();
        }
    }

    public MBBundles load(Reader reader) throws IOException, ClassNotFoundException {
        return (MBBundles)xstream.fromXML(reader);
    }

    public MBBundles load(InputStream in) throws IOException, ClassNotFoundException {
        return (MBBundles)xstream.fromXML(in);
    }

    static {
        xstream.setMode(1001);
        MBXMLPersistencer.configure(xstream);
        xstream_pretty = new XStream((HierarchicalStreamDriver)new JsonHierarchicalStreamDriver());
        xstream_pretty.setMode(1001);
        MBXMLPersistencer.configure(xstream_pretty);
    }
}

