/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LocaleSanityCheckerTask
extends Task {
    private File from;
    private File to;
    private String locale;
    private boolean includeReview = false;

    public void execute() throws BuildException {
        if (this.locale == null) {
            throw new BuildException("locale parameter is needed!");
        }
        if (this.to.exists()) {
            throw new BuildException("Output file already exists:" + this.to.getAbsolutePath());
        }
        try {
            if (!this.to.createNewFile()) {
                throw new BuildException("Could not create result file:" + this.to.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        if (!this.to.canWrite()) {
            throw new BuildException("Cannot write to output file:" + this.to.getAbsolutePath());
        }
        boolean foundMissing = false;
        MBBundles missingTranslations = new MBBundles();
        try {
            MBBundles originalBundles = MBPersistencer.loadFile(this.from);
            for (MBBundle bundle : originalBundles.getBundles()) {
                MBBundle missingBundle = new MBBundle();
                missingBundle.setBaseName(bundle.getBaseName());
                missingBundle.setInterfaceName(bundle.getInterfaceName());
                missingBundle.setSqldomain(bundle.getSqldomain());
                boolean needsBundle = false;
                for (MBEntry entry : bundle.getEntries()) {
                    MBText text = entry.getText(this.locale);
                    if (!this.isMissing(text)) continue;
                    if (!needsBundle) {
                        missingTranslations.getBundles().add(missingBundle);
                        needsBundle = true;
                        foundMissing = true;
                    }
                    missingBundle.getEntries().add(entry);
                }
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (foundMissing) {
            try {
                MBPersistencer.saveFile(missingTranslations, this.to);
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e);
            }
            this.log("missing translations saved as " + this.to.getPath());
        } else {
            this.log("no missing translations found.");
        }
    }

    private boolean isMissing(MBText text) {
        return text == null || this.isIncludeReview() && text.isReview() || text.getValue() == null || text.getValue().equals("");
    }

    public File getFrom() {
        return this.from;
    }

    public void setFrom(File from) {
        this.from = from;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File to) {
        this.to = to;
    }

    public boolean isIncludeReview() {
        return this.includeReview;
    }

    public void setIncludeReview(boolean includeReview) {
        this.includeReview = includeReview;
    }
}

