/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.BundleWriterExcel;
import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ListChangesTask
extends Task {
    private File original;
    private File newer;
    private File results;
    private String locales;
    private boolean ignoreMissingKeys = false;

    public void execute() throws BuildException {
        ArrayList<String> diffs = new ArrayList<String>();
        try {
            MBBundles originalBundles = MBPersistencer.loadFile(this.original);
            MBBundles newBundles = MBPersistencer.loadFile(this.newer);
            HashSet<String> locales = new HashSet<String>();
            if (this.locales == null || this.locales.length() == 0) {
                for (MBBundle each : originalBundles.getBundles()) {
                    locales.addAll(new BundleWriterExcel(each).getLocalesUsed());
                }
            } else {
                StringTokenizer localesTokens = new StringTokenizer(this.locales, ";");
                while (localesTokens.hasMoreTokens()) {
                    String locale = localesTokens.nextToken();
                    locales.add(locale);
                }
            }
            ArrayList localeOrdered = new ArrayList(locales);
            Collections.sort(localeOrdered);
            for (String locale : localeOrdered) {
                this.log("Checking locale:" + locale);
                for (MBBundle originalBundle : originalBundles.getBundles()) {
                    for (MBEntry originalEntry : originalBundle.getEntries()) {
                        String newTextValue;
                        MBText newText = newBundles == null ? null : newBundles.findMBTextForLocale(originalEntry.getKey(), locale);
                        String originalTextValue = originalEntry.getText(locale) == null ? "" : originalEntry.getText(locale).getValue();
                        String string = newTextValue = newText == null ? "" : newText.getValue();
                        if (this.ignoreMissingKeys && newText == null || originalTextValue.equals(newTextValue)) continue;
                        String diffDescription = "(" + locale + ") key= " + originalEntry.getKey() + "- ORIGINAL= '" + originalTextValue + "' <-> ";
                        diffDescription = newText == null ? diffDescription + "NEW: null" : diffDescription + "NEW: '" + newTextValue + "'";
                        this.log(diffDescription);
                        diffs.add(diffDescription);
                    }
                }
            }
            FileWriter writer = new FileWriter(this.results);
            for (String diff : diffs) {
                ((Writer)writer).append(diff).append("\n");
            }
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public File getOriginal() {
        return this.original;
    }

    public void setOriginal(File original) {
        this.original = original;
    }

    public File getNewer() {
        return this.newer;
    }

    public void setNewer(File newer) {
        this.newer = newer;
    }

    public File getResults() {
        return this.results;
    }

    public void setResults(File results) {
        this.results = results;
    }

    public String getLocales() {
        return this.locales;
    }

    public void setLocales(String locales) {
        this.locales = locales;
    }

    public boolean isIgnoreMissingKeys() {
        return this.ignoreMissingKeys;
    }

    public void setIgnoreMissingKeys(boolean ignoreMissingKeys) {
        this.ignoreMissingKeys = ignoreMissingKeys;
    }
}

