/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.tasks;

import de.viaboxx.nlstools.formats.MBPersistencer;
import de.viaboxx.nlstools.formats.MBXMLPersistencer;
import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBBundles;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import de.viaboxx.nlstools.tasks.MergeLocaleTask;
import java.io.File;
import java.util.StringTokenizer;

public class DiffMergeLocaleTask
extends MergeLocaleTask {
    private String origin;
    private String current;
    private String conflicts;
    private MBBundles originBundles;
    private MBBundles conflictsBundles;

    protected void processExecute() {
        if (this.loadedBundles != null) {
            for (MBBundle bundle : this.loadedBundles.getBundles()) {
                for (MBEntry entry : bundle.getEntries()) {
                    StringTokenizer tokens = new StringTokenizer(this.getLocales(), ";");
                    while (tokens.hasMoreTokens()) {
                        MBEntry conflictEntry;
                        MBBundle conflictBundle;
                        String locale = tokens.nextToken();
                        MBText tmpText = null;
                        for (MBText text : entry.getTexts()) {
                            if (!text.getLocale().equals(locale)) continue;
                            tmpText = text;
                        }
                        if (tmpText == null) {
                            tmpText = new MBText();
                            tmpText.setLocale(locale);
                            tmpText.setValue("");
                            entry.getTexts().add(tmpText);
                        }
                        MBText translatedText = this.findMBTextForLocale(entry.getKey(), locale, this.translatedBundles);
                        MBText originText = this.findMBTextForLocale(entry.getKey(), locale, this.originBundles);
                        if (translatedText == null) continue;
                        if (!(originText == null || originText.equals(translatedText) || translatedText.equals(tmpText) || originText.equals(tmpText))) {
                            conflictBundle = this.getConflictBundle(bundle);
                            conflictEntry = entry.copy();
                            conflictEntry.setKey(conflictEntry.getKey() + ".transl");
                            conflictEntry.getTexts().add(translatedText);
                            conflictBundle.getEntries().add(conflictEntry);
                            conflictEntry = entry.copy();
                            conflictEntry.setKey(conflictEntry.getKey() + ".current");
                            conflictEntry.getTexts().add(tmpText);
                            conflictBundle.getEntries().add(conflictEntry);
                            continue;
                        }
                        if (originText != null && originText.equals(translatedText) && !originText.equals(tmpText)) {
                            conflictBundle = this.getConflictBundle(bundle);
                            conflictEntry = entry.copy();
                            conflictEntry.setKey(conflictEntry.getKey() + ".origin");
                            conflictEntry.getTexts().add(originText);
                            conflictBundle.getEntries().add(conflictEntry);
                            conflictEntry = entry.copy();
                            conflictEntry.setKey(conflictEntry.getKey() + ".transl");
                            conflictEntry.getTexts().add(translatedText);
                            conflictBundle.getEntries().add(conflictEntry);
                            conflictEntry = entry.copy();
                            conflictEntry.setKey(conflictEntry.getKey() + ".current");
                            conflictEntry.getTexts().add(tmpText);
                            conflictBundle.getEntries().add(conflictEntry);
                            continue;
                        }
                        tmpText.setValue(translatedText.getValue());
                    }
                }
            }
        }
    }

    private MBBundle getConflictBundle(MBBundle bundle) {
        MBBundle conflictBundle;
        if (this.conflictsBundles == null) {
            this.conflictsBundles = new MBBundles();
        }
        if ((conflictBundle = this.conflictsBundles.getBundle(bundle.getBaseName())) == null) {
            conflictBundle = bundle.copy();
            conflictBundle.getEntries().clear();
            this.conflictsBundles.getBundles().add(conflictBundle);
        }
        return conflictBundle;
    }

    protected void loadExecute() throws Exception {
        super.loadExecute();
        if (this.getOrigin() != null) {
            this.log("Reading Bundles from " + this.getOrigin(), 2);
            this.originBundles = MBPersistencer.loadFile(new File(this.getOrigin()));
        }
    }

    protected void outputExecute() throws Exception {
        if (this.conflictsBundles != null) {
            if (this.conflicts != null) {
                MBPersistencer.saveFile(this.conflictsBundles, new File(this.conflicts));
                this.log("Merged and writing conflict bundles to " + this.conflicts, 2);
            } else {
                this.log("Merged with conflicts found: \n" + MBXMLPersistencer.getXstream().toXML((Object)this.conflictsBundles), 2);
            }
        } else if (this.conflicts != null) {
            this.log("Merged without conflicts - writing empty bundles to " + this.conflicts, 2);
            MBPersistencer.saveFile(new MBBundles(), new File(this.conflicts));
        } else {
            this.log("Merged without conflicts", 2);
        }
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(String conflicts) {
        this.conflicts = conflicts;
    }

    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }
}

