/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.formats.MBExcelPersistencer;
import de.viaboxx.nlstools.formats.MBInMemoryPersistencer;
import de.viaboxx.nlstools.formats.MBJSONPersistencer;
import de.viaboxx.nlstools.formats.MBXMLPersistencer;
import de.viaboxx.nlstools.model.MBBundles;
import java.io.File;

public abstract class MBPersistencer {
    public abstract void save(MBBundles var1, File var2) throws Exception;

    protected void mkdirs(File target) {
        File dir = target.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
    }

    public abstract MBBundles load(File var1) throws Exception;

    public static MBPersistencer forFile(String aFile) {
        return MBPersistencer.forFile(new File(aFile));
    }

    public static MBPersistencer forFile(File aFile) {
        String name = aFile.getName().toLowerCase();
        if (name.endsWith(".xls")) {
            return new MBExcelPersistencer();
        }
        if (name.endsWith(".xml")) {
            return new MBXMLPersistencer();
        }
        if (name.endsWith(".js")) {
            return new MBJSONPersistencer(true);
        }
        if (name.endsWith(".mem")) {
            return new MBInMemoryPersistencer();
        }
        throw new IllegalArgumentException("File type not supported: " + aFile);
    }

    public static MBBundles loadFile(File aFile) throws Exception {
        return MBPersistencer.forFile(aFile).load(aFile);
    }

    public static void saveFile(MBBundles obj, File aFile) throws Exception {
        obj.sort();
        MBPersistencer.forFile(aFile).save(obj, aFile);
    }
}

