/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nlstools.formats;

import de.viaboxx.nlstools.model.MBBundle;
import de.viaboxx.nlstools.model.MBEntry;
import de.viaboxx.nlstools.model.MBText;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BundleWriter {
    protected final Task task;
    protected final MBBundle currentBundle;
    protected final String configFile;
    protected final String outputPath;
    protected final FileType fileType;
    protected boolean overwrite = false;
    protected boolean deleteOldFiles = true;
    private boolean debugMode;
    protected boolean flexLayout = false;
    protected Set<String> allowedLocales;
    protected List<String> myUsedLocales;

    public BundleWriter(Task task, String configFile, MBBundle currentBundle, String outputPath, FileType fileType, Set<String> allowedLocales) {
        this.task = task;
        this.configFile = configFile;
        this.currentBundle = currentBundle;
        this.outputPath = outputPath;
        this.fileType = fileType;
        this.allowedLocales = allowedLocales == null ? new HashSet() : allowedLocales;
    }

    public void execute() throws Exception {
        if (!this.fileType.equals((Object)FileType.NO)) {
            if (!this.overwrite && !this.needsNewFiles()) {
                this.task.log(this.suffix() + " file(s) for " + this.getCurrentBundle().getBaseName() + " up to date", 3);
            } else {
                this.writeOutputFiles();
            }
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void setDeleteOldFiles(boolean deleteOldFiles) {
        this.deleteOldFiles = deleteOldFiles;
    }

    public boolean isFlexLayout() {
        return this.flexLayout;
    }

    public void setFlexLayout(boolean flexLayout) {
        this.flexLayout = flexLayout;
    }

    protected boolean mkdirs(String file) {
        File dir = new File(file).getParentFile();
        if (dir != null && !dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    protected void writeOutputFiles() throws Exception {
        this.deleteFiles();
        for (String locale : this.getLocalesUsed()) {
            if (!this.allowedLocales.isEmpty() && !this.allowedLocales.contains(locale)) continue;
            this.writeOutputFilePerLocale(locale);
        }
    }

    protected void writeOutputFilePerLocale(String locale) throws Exception {
    }

    protected void deleteFiles() {
        if (this.deleteOldFiles) {
            StringBuilder baseName = this.buildOutputFileNameBase();
            File dir = new File(this.getOutputPath());
            if (dir.exists()) {
                if (this.fileType.equals((Object)FileType.XML)) {
                    this.deleteFiles(baseName.append("*.xml").toString());
                } else if (this.fileType.equals((Object)FileType.PROPERTIES)) {
                    this.deleteFiles(baseName.append("*.properties").toString());
                } else if (this.fileType.equals((Object)FileType.JS)) {
                    this.deleteFiles(baseName.append("*.js").toString());
                }
            }
        }
    }

    protected StringBuilder buildOutputFileNameBase() {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getOutputPath());
        fileName.append("/");
        fileName.append(this.getCurrentBundle().getBaseName());
        return fileName;
    }

    protected StringBuilder buildOutputFileNameBase(String locale) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.getOutputPath());
        if (locale != null && locale.length() > 0) {
            fileName.append("/");
            fileName.append(locale);
        }
        fileName.append("/");
        fileName.append(this.getCurrentBundle().getBaseName());
        return fileName;
    }

    protected void deleteFiles(String filePattern) {
        Delete delete = (Delete)this.task.getProject().createTask("delete");
        FileSet fs = new FileSet();
        File file = new File(filePattern);
        fs.setDir(file.getParentFile());
        fs.setIncludes(file.getName());
        fs.setProject(this.task.getProject());
        delete.setFailOnError(false);
        delete.addFileset(fs);
        delete.execute();
    }

    protected boolean needsNewFiles() throws FileNotFoundException {
        Iterator<String> locales = this.getLocalesUsed().iterator();
        boolean result = false;
        while (locales.hasNext()) {
            String each = locales.next();
            File outfile = new File(this.getFileName(each));
            if (!outfile.exists()) {
                result = true;
            } else {
                File infile = new File(this.configFile);
                if (!infile.exists()) {
                    throw new FileNotFoundException(infile + " not found");
                }
                if (infile.lastModified() > outfile.lastModified()) {
                    result = true;
                }
            }
            if (!result) continue;
            this.task.log(outfile.getPath() + " is outdated!", 4);
            break;
        }
        return result;
    }

    protected String getOutputPathName() {
        String result = this.buildOutputFileNameBase().toString();
        return result.substring(0, result.lastIndexOf(47));
    }

    protected String getFileName(String locale) {
        if (this.flexLayout) {
            return this.getFileNameFlex(locale);
        }
        return this.getFileNameJava(locale);
    }

    protected String getFileNameJava(String locale) {
        StringBuilder fileName = this.buildOutputFileNameBase();
        if (locale != null && locale.length() > 0) {
            fileName.append("_");
            fileName.append(locale);
        }
        fileName.append(this.suffix());
        return fileName.toString();
    }

    protected String getFileNameFlex(String locale) {
        StringBuilder fileName = this.buildOutputFileNameBase(locale);
        fileName.append(this.suffix());
        return fileName.toString();
    }

    protected abstract String suffix();

    public String getOutputPath() {
        return this.outputPath;
    }

    protected List<String> getLocalesUsed() {
        if (this.myUsedLocales == null) {
            HashSet<String> locales = new HashSet<String>();
            if (this.getCurrentBundle().getEntries() != null) {
                for (MBEntry eachEntry : this.getCurrentBundle().getEntries()) {
                    if (eachEntry.getTexts() == null) continue;
                    for (MBText eachText : eachEntry.getTexts()) {
                        locales.add(eachText.getLocale());
                    }
                }
            }
            ArrayList<String> result = new ArrayList<String>(locales);
            Collections.sort(result);
            this.myUsedLocales = result;
        }
        return this.myUsedLocales;
    }

    protected MBBundle getCurrentBundle() {
        return this.currentBundle;
    }

    protected Properties createProperties(String aLocale) {
        Iterator<MBEntry> entries = this.getCurrentBundle().getEntries().iterator();
        Properties p = new Properties();
        while (entries.hasNext()) {
            int indentIndex;
            MBEntry eachEntry = entries.next();
            String key = eachEntry.getKey();
            MBText langText = eachEntry.getText(aLocale);
            if (langText == null && aLocale != null && !"".equals(aLocale)) {
                langText = eachEntry.getText("");
            }
            if (langText == null) continue;
            String value = !this.debugMode ? langText.getValue() : key;
            while (value != null && (indentIndex = value.indexOf("\n ")) > -1) {
                int lastBlankIndex = indentIndex + 1;
                while (lastBlankIndex + 1 < value.length() && Character.isWhitespace(value.charAt(lastBlankIndex + 1))) {
                    ++lastBlankIndex;
                }
                value = value.substring(0, indentIndex) + ' ' + value.substring(lastBlankIndex + 1);
            }
            this.task.log("'" + key + "' ==> '" + value + "'", 4);
            if (key == null || value == null) continue;
            p.setProperty(key, value);
        }
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        NO,
        XML,
        PROPERTIES,
        JS,
        JS_PRETTY,
        JAVA_FULL_ENUM_KEYS,
        JAVA_ENUM_KEYS,
        JAVA_FULL,
        JAVA_SMALL,
        SQL,
        FLEX_FULL,
        FLEX_SMALL;

    }
}

