/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.markdown.utils;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Util {
    private static final char[] HEXES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String computeMd5(InputStream is) throws NoSuchAlgorithmException, IOException {
        if (is == null) {
            return null;
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        try {
            int read;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            String string = Md5Util.toHex(digest.digest());
            return string;
        }
        finally {
            is.close();
        }
    }

    private static String toHex(byte[] raw) {
        if (raw.length != 16) {
            throw new IllegalArgumentException("length must be 16, not " + raw.length);
        }
        char[] hex = new char[32];
        int i = 0;
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex[i] = HEXES[(b & 0xF0) >> 4];
            hex[i + 1] = HEXES[b & 0xF];
            i = (short)(i + 2);
            ++n2;
        }
        return new String(hex);
    }
}

