/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tikz;

import java.awt.Color;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.version.Version;

public class TikzGraphics {
    private final List<String> cmd = new ArrayList<String>();
    private Color color = Color.BLACK;
    private Color fillcolor = Color.BLACK;
    private double thickness = 1.0;
    private String dash = null;
    private final Map<Color, String> colornames = new LinkedHashMap<Color, String>();

    private String getColorName(Color color) {
        if (color.equals(Color.WHITE)) {
            return "white";
        }
        if (color.equals(Color.BLACK)) {
            return "black";
        }
        String string = this.colornames.get(color);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public void createData(OutputStream outputStream) throws IOException {
        this.out(outputStream, "\\documentclass{article}");
        this.out(outputStream, "\\usepackage{tikz}");
        this.out(outputStream, "\\begin{document}");
        this.out(outputStream, "% generated by Plantuml " + Version.versionString());
        for (Map.Entry<Color, String> object : this.colornames.entrySet()) {
            this.out(outputStream, this.definecolor(object.getValue(), object.getKey()));
        }
        this.out(outputStream, "\\begin{tikzpicture}[yscale=-1]");
        for (String string : this.cmd) {
            this.out(outputStream, string);
        }
        this.out(outputStream, "\\end{tikzpicture}");
        this.out(outputStream, "\\end{document}");
    }

    private String definecolor(String string, Color color) {
        return "\\definecolor{" + string + "}{RGB}{" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "}";
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
            if (this.color == null) {
                stringBuilder.append("color=" + this.getColorName(this.fillcolor) + ",");
            }
        }
        stringBuilder.append("line width=" + this.thickness + "pt] ");
        stringBuilder.append(this.couple(d, d2) + " rectangle " + this.couple(d + d3, d2 + d4));
        stringBuilder.append(";");
        this.cmd.add(stringBuilder.toString());
    }

    private String couple(double d, double d2) {
        return "(" + this.format(d) + "pt," + this.format(d2) + "pt)";
    }

    private String format(double d) {
        return EpsGraphics.format(d);
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }

    public void text(double d, double d2, String string) {
        String string2 = "\\node at " + this.couple(d, d2) + "[below right]{" + string + "};";
        this.cmd.add(string2);
    }

    public void line(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt");
        if (this.dash != null) {
            stringBuilder.append(",dash pattern=" + this.dash);
        }
        stringBuilder.append("] ");
        stringBuilder.append(this.couple(d, d2));
        stringBuilder.append(" -- ");
        stringBuilder.append(this.couple(d3, d4));
        stringBuilder.append(";");
        this.cmd.add(stringBuilder.toString());
    }

    public void polygon(double[] dArray) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt]");
        stringBuilder.append(" ");
        for (int i = 0; i < dArray.length; i += 2) {
            stringBuilder.append(this.couple(dArray[i], dArray[i + 1]));
            stringBuilder.append(" -- ");
        }
        stringBuilder.append("cycle;");
        this.cmd.add(stringBuilder.toString());
    }

    public void upath(double d, double d2, UPath uPath) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[color=" + this.getColorName(this.color) + ",line width=" + this.thickness + "pt] ");
        for (USegment uSegment : uPath) {
            USegmentType uSegmentType = uSegment.getSegmentType();
            double[] dArray = uSegment.getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                stringBuilder.append(" -- ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                throw new UnsupportedOperationException();
            }
            if (uSegmentType == USegmentType.SEG_CUBICTO) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" and ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[4] + d, dArray[5] + d2));
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown " + uSegment);
        }
        stringBuilder.append(";");
        this.cmd.add(stringBuilder.toString());
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\draw[");
        if (this.color != null) {
            stringBuilder.append("color=" + this.getColorName(this.color) + ",");
        }
        if (this.fillcolor != null) {
            stringBuilder.append("fill=" + this.getColorName(this.fillcolor) + ",");
        }
        stringBuilder.append("line width=" + this.thickness + "pt] " + this.couple(d, d2) + " ellipse (" + this.format(d3) + "pt and " + this.format(d4) + "pt);");
        this.cmd.add(stringBuilder.toString());
    }

    public void drawPathIterator(double d, double d2, PathIterator pathIterator) {
        StringBuilder stringBuilder = new StringBuilder("\\draw[color=" + this.getColorName(this.color) + ",fill=" + this.getColorName(this.color) + "] ");
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
            } else if (n == 1) {
                stringBuilder.append(" -- ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
            } else if (n == 4) {
                stringBuilder.append(";");
                this.cmd.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                stringBuilder.append("\\draw ");
            } else if (n == 3) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" and ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[4] + d, dArray[5] + d2));
            } else if (n == 2) {
                stringBuilder.append(" ..controls ");
                stringBuilder.append(this.couple(dArray[0] + d, dArray[1] + d2));
                stringBuilder.append(" .. ");
                stringBuilder.append(this.couple(dArray[2] + d, dArray[3] + d2));
            } else {
                throw new UnsupportedOperationException("code=" + n);
            }
            pathIterator.next();
        }
    }

    public void setFillColor(Color color) {
        this.fillcolor = color;
        this.addColor(color);
    }

    public void setStrokeColor(Color color) {
        this.color = color;
        this.addColor(color);
    }

    private void addColor(Color color) {
        if (color == null) {
            return;
        }
        if (this.colornames.containsKey(color)) {
            return;
        }
        String string = "plantucolor" + String.format("%04d", this.colornames.size());
        this.colornames.put(color, string);
    }

    public void setStrokeWidth(double d, String string) {
        this.thickness = d;
        this.dash = string;
    }
}

