/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentBlueModernEnglober
extends AbstractTextualComponent {
    private final HtmlColor borderColor;
    private final HtmlColor backColor;

    public ComponentBlueModernEnglober(HtmlColor htmlColor, HtmlColor htmlColor2, Display display, HtmlColor htmlColor3, HtmlColor htmlColor4, UFont uFont, ISkinSimple iSkinSimple) {
        super(display, htmlColor3, htmlColor4, uFont, HorizontalAlignment.CENTER, 4, 4, 1, iSkinSimple, 0.0, false);
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
    }

    protected void drawBackgroundInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        uGraphic = uGraphic.apply(new UChangeColor(this.borderColor));
        uGraphic = uGraphic.apply(new UChangeBackColor(this.backColor));
        uGraphic.apply(new UStroke(2.0)).draw(new URectangle(dimension2D.getWidth(), dimension2D.getHeight(), 9.0, 9.0));
        double d = (dimension2D.getWidth() - this.getPureTextWidth(uGraphic.getStringBounder())) / 2.0;
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(d, 0.0)));
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 10.0;
    }
}

