/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ElseTile
implements Tile {
    private final Skin skin;
    private final ISkinParam skinParam;
    private final GroupingLeaf anElse;
    private final Tile parent;

    public Event getEvent() {
        return this.anElse;
    }

    public ElseTile(GroupingLeaf groupingLeaf, Skin skin, ISkinParam iSkinParam, Tile tile) {
        this.anElse = groupingLeaf;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.parent = tile;
    }

    private Component getComponent(StringBounder stringBounder) {
        Display display = Display.create(this.anElse.getTitle());
        Component component = this.skin.createComponent(ComponentType.GROUPING_ELSE, null, this.skinParam, display);
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        Real real = this.getMinX(stringBounder);
        Real real2 = this.getMaxX(stringBounder);
        Area area = new Area(real2.getCurrentValue() - real.getCurrentValue(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(real.getCurrentValue(), 0.0));
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.parent.getMinX(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.parent.getMaxX(stringBounder);
    }
}

