/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPathSvg
extends DriverShadowedG2d
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPathSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UPath uPath = (UPath)uShape;
        String string = StringUtils.getAsSvg(colorMapper, uParam.getColor());
        if (uPath.isOpenIconic()) {
            svgGraphics.setFillColor(string);
            svgGraphics.setStrokeColor("");
            svgGraphics.setStrokeWidth(0.0, "");
        } else {
            HtmlColor htmlColor = uParam.getBackcolor();
            if (htmlColor instanceof HtmlColorGradient) {
                HtmlColorGradient htmlColorGradient = (HtmlColorGradient)htmlColor;
                String string2 = svgGraphics.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor2())), htmlColorGradient.getPolicy());
                svgGraphics.setFillColor("url(#" + string2 + ")");
            } else {
                String string3 = StringUtils.getAsSvg(colorMapper, htmlColor);
                svgGraphics.setFillColor(string3);
            }
            svgGraphics.setStrokeColor(string);
            svgGraphics.setStrokeWidth(uParam.getStroke().getThickness(), uParam.getStroke().getDasharraySvg());
        }
        svgGraphics.svgPath(d, d2, uPath, uPath.getDeltaShadow());
    }
}

