/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final FileFormat fileFormat;
    private final ColorMapper colorMapper;
    private final double dpiFactor;
    private final HtmlColor mybackcolor;
    private final String metadata;
    private final String warningOrError;
    private final double margin1;
    private final double margin2;
    private UDrawable udrawable;

    public ImageBuilder(FileFormat fileFormat, ColorMapper colorMapper, double d, HtmlColor htmlColor, String string, String string2, double d2, double d3) {
        this.fileFormat = fileFormat;
        this.colorMapper = colorMapper;
        this.dpiFactor = d;
        this.mybackcolor = htmlColor;
        this.metadata = string;
        this.warningOrError = string2;
        this.margin1 = d2;
        this.margin2 = d3;
    }

    public void addUDrawable(UDrawable uDrawable) {
        this.udrawable = uDrawable;
    }

    public ImageData writeImageTOBEMOVED(OutputStream outputStream) throws IOException {
        Set<Url> set;
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        UGraphic2 uGraphic2 = this.createUGraphic(dimension2DDouble);
        this.udrawable.drawU(uGraphic2.apply(new UTranslate(this.margin1, this.margin1)));
        uGraphic2.writeImageTOBEMOVED(outputStream, this.metadata, 96);
        outputStream.flush();
        if (uGraphic2 instanceof UGraphicG2d && (set = ((UGraphicG2d)uGraphic2).getAllUrlsEncountered()).size() > 0) {
            CMapData cMapData = CMapData.cmapString(set, this.dpiFactor);
            return new ImageDataComplex(dimension2DDouble, cMapData, this.warningOrError);
        }
        return new ImageDataSimple(dimension2DDouble);
    }

    private UGraphic2 createUGraphic(Dimension2D dimension2D) {
        switch (this.fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor);
            }
            case SVG: {
                return this.createUGraphicSVG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor);
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper);
            }
        }
        throw new UnsupportedOperationException(this.fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        }
        UGraphicSvg uGraphicSvg = htmlColor instanceof HtmlColorGradient ? new UGraphicSvg(colorMapper, (HtmlColorGradient)htmlColor, false, d) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(colorMapper, false, d) : new UGraphicSvg(colorMapper, StringUtils.getAsHtml(color), false, d));
        return uGraphicSvg;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        } else if (htmlColor instanceof HtmlColorTransparent) {
            color = null;
        }
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, d);
        uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (htmlColor instanceof HtmlColorGradient) {
            uGraphicG2d.apply(new UChangeBackColor(htmlColor)).draw(new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return uGraphicG2d;
    }
}

