/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLollipopInterfaceEye2
extends AbstractEntityImage {
    public static final double SIZE = 14.0;
    private final TextBlock desc;
    private final TextBlock stereo;
    private final SymbolContext ctx;
    private final Url url;

    public EntityImageLollipopInterfaceEye2(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        USymbol uSymbol;
        Stereotype stereotype = iLeaf.getStereotype();
        USymbol uSymbol2 = iLeaf.getUSymbol() == null ? (iSkinParam.useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (uSymbol = iLeaf.getUSymbol());
        if (uSymbol == null) {
            throw new IllegalArgumentException();
        }
        this.desc = new BodyEnhanced(iLeaf.getDisplay(), uSymbol.getFontParam(), iSkinParam, HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false);
        this.url = iLeaf.getUrl99();
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBack(), this.getStereo());
        }
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBorder(), this.getStereo());
        this.ctx = new SymbolContext(htmlColor, htmlColor2).withStroke(new UStroke(1.5)).withShadow(this.getSkinParam().shadowing());
        this.stereo = stereotype != null && stereotype.getLabel() != null && portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf) ? TextBlockUtils.create(Display.getWithNewlines(stereotype.getLabel()), new FontConfiguration(SkinParamUtils.getFont(this.getSkinParam(), uSymbol.getFontParamStereotype(), stereotype), SkinParamUtils.getFontColor(this.getSkinParam(), uSymbol.getFontParamStereotype(), null), this.getSkinParam().getHyperlinkColor()), HorizontalAlignment.CENTER, iSkinParam) : TextBlockUtils.empty(0.0, 0.0);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(14.0, 14.0);
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        UEllipse uEllipse = new UEllipse(14.0, 14.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        this.ctx.apply(uGraphic).draw(uEllipse);
        Dimension2D dimension2D = this.desc.calculateDimension(uGraphic.getStringBounder());
        double d = 7.0 - dimension2D.getWidth() / 2.0;
        this.desc.drawU(uGraphic.apply(new UTranslate(d, 19.599999999999998)));
        Dimension2D dimension2D2 = this.stereo.calculateDimension(uGraphic.getStringBounder());
        double d2 = 7.0 - dimension2D2.getWidth() / 2.0;
        double d3 = -dimension2D2.getHeight();
        this.stereo.drawU(uGraphic.apply(new UTranslate(d2, d3)));
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }

    public int getShield() {
        return 0;
    }
}

