/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import net.sourceforge.plantuml.sequencediagram.teoz.MainTile;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceDiagramFileMakerTeoz
implements FileMaker {
    private final SequenceDiagram diagram;
    private final FileFormatOption fileFormatOption;
    private final Skin skin;

    public SequenceDiagramFileMakerTeoz(SequenceDiagram sequenceDiagram, Skin skin, FileFormatOption fileFormatOption, List<BufferedImage> list) {
        this.diagram = sequenceDiagram;
        this.fileFormatOption = fileFormatOption;
        this.skin = skin;
    }

    @Override
    public ImageData createOne(OutputStream outputStream, int n, boolean bl) throws IOException {
        Object object;
        StringBounder stringBounder = TextBlockUtils.getDummyStringBounder();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        Real real = RealUtils.createOrigin();
        Real real2 = real.addAtLeast(0.0);
        double d = 0.0;
        LivingSpace livingSpace = null;
        LivingSpaces livingSpaces = new LivingSpaces();
        for (Participant participant : this.diagram.participants().values()) {
            LivingSpace livingSpace2;
            livingSpace = livingSpace2 = new LivingSpace(participant, this.diagram.getEnglober(participant), this.skin, iSkinParam, real2, this.diagram.events());
            livingSpaces.put(participant, livingSpace2);
            object = livingSpace2.getHeadPreferredDimension(stringBounder);
            real2 = livingSpace2.getPosD(stringBounder).addAtLeast(0.0);
            d = Math.max(d, ((Dimension2D)object).getHeight());
        }
        MainTile mainTile = new MainTile(this.diagram, this.skin, livingSpace.getPosD(stringBounder).addAtLeast(0.0), livingSpaces, real);
        mainTile.addConstraints(stringBounder);
        real.compile();
        double d2 = mainTile.getPreferredHeight(stringBounder) + 2.0 * d;
        object = mainTile.getMinX(stringBounder);
        Real real3 = mainTile.getMaxX(stringBounder);
        System.err.println("min1=" + object.getCurrentValue());
        System.err.println("max1=" + real3.getCurrentValue());
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(real3.getCurrentValue() - object.getCurrentValue(), d2);
        UGraphic2 uGraphic2 = (UGraphic2)this.fileFormatOption.createUGraphic(dimension2DDouble).apply(new UTranslate(-object.getCurrentValue(), 0.0));
        stringBounder = uGraphic2.getStringBounder();
        this.drawHeads(uGraphic2, livingSpaces);
        mainTile.drawU(uGraphic2.apply(new UTranslate(0.0, d)));
        this.drawLifeLines(uGraphic2.apply(new UTranslate(0.0, d)), mainTile.getPreferredHeight(stringBounder), livingSpaces);
        this.drawHeads(uGraphic2.apply(new UTranslate(0.0, mainTile.getPreferredHeight(stringBounder) + d)), livingSpaces);
        uGraphic2.writeImageTOBEMOVED(outputStream, bl ? this.diagram.getMetadata() : null, this.diagram.getDpi(this.fileFormatOption));
        Dimension2DDouble dimension2DDouble2 = new Dimension2DDouble(((Dimension2D)dimension2DDouble).getWidth(), ((Dimension2D)dimension2DDouble).getHeight());
        return new ImageDataSimple(dimension2DDouble2);
    }

    private void drawLifeLines(UGraphic uGraphic, double d, LivingSpaces livingSpaces) {
        for (LivingSpace livingSpace : livingSpaces.values()) {
            System.err.println("drawing lines " + livingSpace);
            double d2 = livingSpace.getPosC(uGraphic.getStringBounder()).getCurrentValue();
            livingSpace.drawLine(uGraphic.apply(new UTranslate(d2, 0.0)), d);
        }
    }

    private void drawHeads(UGraphic uGraphic, LivingSpaces livingSpaces) {
        for (LivingSpace livingSpace : livingSpaces.values()) {
            System.err.println("drawing heads " + livingSpace);
            double d = livingSpace.getPosB().getCurrentValue();
            livingSpace.drawHead(uGraphic.apply(new UTranslate(d, 0.0)));
        }
    }

    @Override
    public int getNbPages() {
        return 1;
    }
}

