/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class LivingParticipantBox
implements InGroupable {
    private final ParticipantBox participantBox;
    private final LifeLine lifeLine;

    public LivingParticipantBox(ParticipantBox participantBox, LifeLine lifeLine) {
        this.participantBox = participantBox;
        this.lifeLine = lifeLine;
    }

    public ParticipantBox getParticipantBox() {
        return this.participantBox;
    }

    public LifeLine getLifeLine() {
        return this.lifeLine;
    }

    public SegmentColored getLiveThicknessAt(StringBounder stringBounder, double d) {
        double d2 = this.lifeLine.getLeftShift(d);
        assert (d2 >= 0.0);
        double d3 = this.lifeLine.getRightShift(d);
        assert (d3 >= 0.0) : "right=" + d3;
        double d4 = this.participantBox.getCenterX(stringBounder);
        return new SegmentColored(d4 - d2, d4 + d3, null, this.lifeLine.shadowing());
    }

    public void drawLineU(UGraphic uGraphic, double d, double d2, boolean bl, double d3) {
        if (d2 <= d) {
            return;
        }
        double d4 = this.lifeLine.getDestroy();
        if (d4 != 0.0 && d4 > d && d4 < d2) {
            d2 = d4;
        }
        this.participantBox.drawLineU(uGraphic, d, d2, bl, d3);
    }

    public void drawLineU22(UGraphic uGraphic, double d, double d2, boolean bl, double d3) {
        if (d2 <= d) {
            return;
        }
        double d4 = this.lifeLine.getDestroy();
        if (d4 != 0.0 && d4 > d && d4 < d2) {
            d2 = d4;
        }
        this.participantBox.drawLineU22(uGraphic, d, d2, bl, d3);
    }

    public double magicMargin(StringBounder stringBounder) {
        return this.participantBox.magicMargin(stringBounder);
    }

    public void create(double d) {
        this.lifeLine.setCreate(d);
    }

    public double getCreate() {
        return this.lifeLine.getCreate();
    }

    public double getMaxX(StringBounder stringBounder) {
        return this.participantBox.getMaxX(stringBounder);
    }

    public double getMinX(StringBounder stringBounder) {
        return this.participantBox.getStartingX();
    }

    public String toString(StringBounder stringBounder) {
        return this.toString();
    }
}

