/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.DotxMaker;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.svek.MinFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizSolverB {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceDotString(String string) throws IOException {
        File file = new File("dottmpfile" + UniqueSequence.getValue() + ".tmp");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(string);
            Log.info("Creating file " + file);
            Object var4_3 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void traceSvgString(String string) throws IOException {
        File file = new File("svgtmpfile" + UniqueSequence.getValue() + ".svg");
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.print(string);
            Log.info("Creating file " + file);
            Object var4_3 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
    }

    public Dimension2D solve(Cluster cluster, Collection<Path> collection) throws IOException {
        Object object;
        int n;
        String string;
        Pattern pattern;
        Matcher matcher;
        String string2 = new DotxMaker(cluster, collection).createDotString("nodesep=0.2;", "ranksep=0.2;");
        if (OptionFlags.getInstance().isKeepTmpFiles()) {
            GraphvizSolverB.traceDotString(string2);
        }
        MinFinder minFinder = new MinFinder();
        Graphviz graphviz = GraphvizUtils.create(string2, "svg");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProcessState processState = graphviz.createFile3(byteArrayOutputStream);
        byteArrayOutputStream.close();
        if (processState != ProcessState.TERMINATED_OK) {
            throw new IllegalStateException("Timeout2 " + (Object)((Object)processState));
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string3 = new String(byArray, "UTF-8");
        if (OptionFlags.getInstance().isKeepTmpFiles()) {
            GraphvizSolverB.traceSvgString(string3);
        }
        if (!(matcher = (pattern = Pattern.compile("(?m)\\<svg\\s+width=\"(\\d+)pt\"\\s+height=\"(\\d+)pt\"")).matcher(string3)).find()) {
            throw new IllegalStateException();
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = Integer.parseInt(matcher.group(2));
        for (Block object2 : cluster.getRecursiveContents()) {
            string = "b" + object2.getUid();
            n = string3.indexOf("<title>" + string + "</title>");
            if (n == -1) {
                throw new IllegalStateException();
            }
            object = GraphvizSolverB.extractPointsList(string3, n);
            object2.setX(GraphvizSolverB.getMinX(object));
            object2.setY(GraphvizSolverB.getMinY(object) + (double)n3);
            minFinder.manage(object2.getPosition());
        }
        for (Cluster cluster2 : cluster.getSubClusters()) {
            string = "cluster" + cluster2.getUid();
            n = string3.indexOf("<title>" + string + "</title>");
            if (n == -1) {
                throw new IllegalStateException();
            }
            object = GraphvizSolverB.extractPointsList(string3, n);
            cluster2.setX(GraphvizSolverB.getMinX(object));
            cluster2.setY(GraphvizSolverB.getMinY(object) + (double)n3);
            double d = GraphvizSolverB.getMaxX(object) - GraphvizSolverB.getMinX((List<Point2D.Double>)object);
            double d2 = GraphvizSolverB.getMaxY((List<Point2D.Double>)object) - GraphvizSolverB.getMinY((List<Point2D.Double>)object);
            cluster2.setHeight(d2);
            cluster2.setWidth(d);
            minFinder.manage(cluster2.getPosition());
        }
        for (Path path : collection) {
            string = "b" + path.getStart().getUid();
            String string4 = "b" + path.getEnd().getUid();
            object = "<title>" + string + "&#45;&gt;" + string4 + "</title>";
            int n4 = string3.indexOf((String)object);
            if (n4 == -1) {
                throw new IllegalStateException((String)object);
            }
            int n5 = string3.indexOf(" d=\"", n4);
            int n6 = string3.indexOf("\"", n5 + " d=\"".length());
            String string5 = string3.substring(n5 + " d=\"".length(), n6);
            DotPath dotPath = new DotPath(string5, n3);
            path.setDotPath(dotPath);
            minFinder.manage(dotPath.getMinFinder());
            if (path.getLabel() == null) continue;
            List<Point2D.Double> list = GraphvizSolverB.extractPointsList(string3, n4);
            double d = GraphvizSolverB.getMinX(list);
            double d3 = GraphvizSolverB.getMinY(list) + (double)n3;
            path.setLabelPosition(d, d3);
            minFinder.manage(d, d3);
        }
        return new Dimension2DDouble(n2, n3);
    }

    private static List<Point2D.Double> extractPointsList(String string, int n) {
        int n2 = string.indexOf("points=\"", n);
        int n3 = string.indexOf("\"", n2 + "points=\"".length());
        String string2 = string.substring(n2 + "points=\"".length(), n3);
        List<Point2D.Double> list = GraphvizSolverB.getPoints(string2);
        return list;
    }

    private static double getMaxX(List<Point2D.Double> list) {
        double d = list.get((int)0).x;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).x > d)) continue;
            d = list.get((int)i).x;
        }
        return d;
    }

    private static double getMinX(List<Point2D.Double> list) {
        double d = list.get((int)0).x;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).x < d)) continue;
            d = list.get((int)i).x;
        }
        return d;
    }

    private static double getMaxY(List<Point2D.Double> list) {
        double d = list.get((int)0).y;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).y > d)) continue;
            d = list.get((int)i).y;
        }
        return d;
    }

    private static double getMinY(List<Point2D.Double> list) {
        double d = list.get((int)0).y;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get((int)i).y < d)) continue;
            d = list.get((int)i).y;
        }
        return d;
    }

    private static List<Point2D.Double> getPoints(String string) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            double d = Double.parseDouble(stringTokenizer2.nextToken());
            double d2 = Double.parseDouble(stringTokenizer2.nextToken());
            arrayList.add(new Point2D.Double(d, d2));
        }
        return arrayList;
    }

    private void exportPng(String string, File file) throws IOException {
        Graphviz graphviz = GraphvizUtils.create(string, "png");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ProcessState processState = graphviz.createFile3(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        if (processState != ProcessState.TERMINATED_OK) {
            throw new IllegalStateException("Timeout3 " + (Object)((Object)processState));
        }
    }

    private Path getPath(Collection<Path> collection, int n, int n2) {
        for (Path path : collection) {
            if (path.getStart().getUid() != n || path.getEnd().getUid() != n2) continue;
            return path;
        }
        throw new IllegalArgumentException();
    }
}

