/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.XMoveable;

public class Box
implements XMoveable,
Pointable {
    private int x;
    private int y;
    private final int width;
    private final int height;

    public Box(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public String toString() {
        return "Box [" + this.x + "," + this.y + "] " + this.width + "," + this.height;
    }

    public Point2DInt[] getCorners() {
        Point2DInt point2DInt = new Point2DInt(this.getX(), this.getY());
        Point2DInt point2DInt2 = new Point2DInt(this.getX() + this.getWidth(), this.getY());
        Point2DInt point2DInt3 = new Point2DInt(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        Point2DInt point2DInt4 = new Point2DInt(this.getX(), this.getY() + this.getHeight());
        return new Point2DInt[]{point2DInt, point2DInt2, point2DInt3, point2DInt4};
    }

    public Point2DInt[] getCornersOfOneSide(LineSegmentInt lineSegmentInt, int n) {
        Point2DInt[] point2DIntArray = this.getCorners();
        double d = lineSegmentInt.side(point2DIntArray[0]);
        double d2 = lineSegmentInt.side(point2DIntArray[1]);
        double d3 = lineSegmentInt.side(point2DIntArray[2]);
        double d4 = lineSegmentInt.side(point2DIntArray[3]);
        int n2 = 0;
        if (Math.signum(d) == (double)n) {
            ++n2;
        }
        if (Math.signum(d2) == (double)n) {
            ++n2;
        }
        if (Math.signum(d3) == (double)n) {
            ++n2;
        }
        if (Math.signum(d4) == (double)n) {
            ++n2;
        }
        Point2DInt[] point2DIntArray2 = new Point2DInt[n2];
        int n3 = 0;
        if (Math.signum(d) == (double)n) {
            point2DIntArray2[n3++] = point2DIntArray[0];
        }
        if (Math.signum(d2) == (double)n) {
            point2DIntArray2[n3++] = point2DIntArray[1];
        }
        if (Math.signum(d3) == (double)n) {
            point2DIntArray2[n3++] = point2DIntArray[2];
        }
        if (Math.signum(d4) == (double)n) {
            point2DIntArray2[n3++] = point2DIntArray[3];
        }
        assert (n2 == n3);
        return point2DIntArray2;
    }

    public boolean doesIntersect(LineSegmentInt lineSegmentInt) {
        return this.intersect(lineSegmentInt).length > 0;
    }

    public Point2DInt[] intersect(LineSegmentInt lineSegmentInt) {
        if (lineSegmentInt.side(this) != 0.0) {
            return new Point2DInt[0];
        }
        Point2DInt[] point2DIntArray = this.getCorners();
        LineSegmentInt lineSegmentInt2 = new LineSegmentInt(point2DIntArray[0], point2DIntArray[1]);
        LineSegmentInt lineSegmentInt3 = new LineSegmentInt(point2DIntArray[1], point2DIntArray[2]);
        LineSegmentInt lineSegmentInt4 = new LineSegmentInt(point2DIntArray[2], point2DIntArray[3]);
        LineSegmentInt lineSegmentInt5 = new LineSegmentInt(point2DIntArray[3], point2DIntArray[0]);
        Point2DInt point2DInt = lineSegmentInt.getSegIntersection(lineSegmentInt2);
        Point2DInt point2DInt2 = lineSegmentInt.getSegIntersection(lineSegmentInt3);
        Point2DInt point2DInt3 = lineSegmentInt.getSegIntersection(lineSegmentInt4);
        Point2DInt point2DInt4 = lineSegmentInt.getSegIntersection(lineSegmentInt5);
        if (point2DInt2 != null && point2DInt2.equals(point2DInt)) {
            point2DInt2 = null;
        }
        if (point2DInt3 != null && (point2DInt3.equals(point2DInt) || point2DInt3.equals(point2DInt2))) {
            point2DInt3 = null;
        }
        if (point2DInt4 != null && (point2DInt4.equals(point2DInt) || point2DInt4.equals(point2DInt2) || point2DInt4.equals(point2DInt3))) {
            point2DInt4 = null;
        }
        int n = this.countNotNull(point2DInt, point2DInt2, point2DInt3, point2DInt4);
        assert (n >= 0 && n <= 3) : n;
        int n2 = 0;
        Point2DInt[] point2DIntArray2 = new Point2DInt[n];
        if (point2DInt != null) {
            point2DIntArray2[n2++] = point2DInt;
        }
        if (point2DInt2 != null) {
            point2DIntArray2[n2++] = point2DInt2;
        }
        if (point2DInt3 != null) {
            point2DIntArray2[n2++] = point2DInt3;
        }
        if (point2DInt4 != null) {
            point2DIntArray2[n2++] = point2DInt4;
        }
        assert (n2 == n);
        assert (this.getCornersOfOneSide(lineSegmentInt, 0).length + this.getCornersOfOneSide(lineSegmentInt, 1).length + this.getCornersOfOneSide(lineSegmentInt, -1).length == 4);
        return point2DIntArray2;
    }

    private int countNotNull(Point2DInt point2DInt, Point2DInt point2DInt2, Point2DInt point2DInt3, Point2DInt point2DInt4) {
        int n = 0;
        if (point2DInt != null) {
            ++n;
        }
        if (point2DInt2 != null) {
            ++n;
        }
        if (point2DInt3 != null) {
            ++n;
        }
        if (point2DInt4 != null) {
            ++n;
        }
        return n;
    }

    public Box outerBox(int n) {
        return new Box(this.x - n, this.y - n, this.width + 2 * n, this.height + 2 * n);
    }

    public Point2DInt getCenterPoint() {
        return new Point2DInt(this.x + this.width / 2, this.y + this.height / 2);
    }

    public void moveX(int n) {
        this.x += n;
    }

    public boolean intersectBox(Box box) {
        return box.x + box.width > this.x && box.y + box.height > this.y && box.x < this.x + this.width && box.y < this.y + this.height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public int getMinX() {
        return this.x;
    }

    public int getMinY() {
        return this.y;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    public Point2DInt getPosition() {
        return this.getCenterPoint();
    }
}

