/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemCreole
extends AbstractPSystem {
    private final List<String> lines = new ArrayList<String>();

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Creole)", this.getClass());
    }

    public void doCommandLine(String string) {
        this.lines.add(string);
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        Display display = Display.create(this.lines);
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE);
        Sheet sheet = new CreoleParser(fontConfiguration, HorizontalAlignment.LEFT, null, false).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, 0.0);
        ImageBuilder imageBuilder = new ImageBuilder(fileFormatOption.getFileFormat(), new ColorMapperIdentity(), 1.0, null, null, null, 0.0, 0.0);
        imageBuilder.addUDrawable(sheetBlock1);
        return imageBuilder.writeImageTOBEMOVED(outputStream);
    }
}

