/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.Set;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMarged;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileGroup
extends AbstractFtile {
    private final double diffYY2 = 20.0;
    private final Ftile inner;
    private final TextBlock name;
    private final HtmlColor color;
    private final HtmlColor backColor;
    private final HtmlColor titleColor;

    public FtileGroup(Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, ISkinSimple iSkinSimple) {
        super(ftile.shadowing());
        this.backColor = htmlColor2 == null ? HtmlColorUtils.WHITE : htmlColor2;
        this.inner = new FtileMarged(ftile, 10.0);
        this.color = htmlColor;
        this.titleColor = htmlColor3;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE);
        this.name = display == null ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.inner.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.inner.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.inner.getSwimlaneOut();
    }

    private double diffYY1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        return Math.max(25.0, dimension2D.getHeight() + 20.0);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        double d = this.suppWidth(stringBounder);
        return new UTranslate(d / 2.0, this.diffYY1(stringBounder));
    }

    public double suppWidth(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        double d = Math.max(ftileGeometry.getWidth(), dimension2D.getWidth() + 20.0) - ftileGeometry.getWidth();
        return d;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.inner.calculateDimension(stringBounder);
        double d = this.suppWidth(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(ftileGeometry.getWidth() + d, ftileGeometry.getHeight() + this.diffYY1(stringBounder) + 20.0, ftileGeometry.getLeft() + d / 2.0, ftileGeometry.getInY() + this.diffYY1(stringBounder), ftileGeometry.getOutY() + this.diffYY1(stringBounder));
        }
        return new FtileGeometry(ftileGeometry.getWidth() + d, ftileGeometry.getHeight() + this.diffYY1(stringBounder) + 20.0, ftileGeometry.getLeft() + d / 2.0, ftileGeometry.getInY() + this.diffYY1(stringBounder));
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        SymbolContext symbolContext = new SymbolContext(this.backColor, HtmlColorUtils.BLACK).withShadow(this.shadowing()).withStroke(new UStroke(2.0));
        USymbol.FRAME.asBig(this.name, TextBlockUtils.empty(0.0, 0.0), ((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry).getHeight(), symbolContext).drawU(uGraphic);
        uGraphic.apply(this.getTranslate(stringBounder)).draw(this.inner);
    }
}

