/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Comparator;
import net.sourceforge.plantuml.BasicEnsureVisible;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.cucadiagram.dot.DotMaker2;

public class Url
implements EnsureVisible {
    private final String url;
    private final String tooltip;
    private final String label;
    private boolean member;
    private final BasicEnsureVisible visible = new BasicEnsureVisible();
    public static final Comparator<Url> SURFACE_COMPARATOR = new Comparator<Url>(){

        @Override
        public int compare(Url url, Url url2) {
            double d;
            double d2 = url.visible.getSurface();
            if (d2 > (d = url2.visible.getSurface())) {
                return 1;
            }
            if (d2 < d) {
                return -1;
            }
            return 0;
        }
    };

    public Url(String string, String string2) {
        this(string, string2, null);
    }

    public Url(String string, String string2, String string3) {
        if (string.contains("{")) {
            throw new IllegalArgumentException(string);
        }
        this.url = string;
        this.tooltip = string2 == null ? string : string2;
        this.label = string3 == null ? string : string3;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getTooltip() {
        return this.tooltip;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return super.toString() + " " + this.url + " " + this.visible.getCoords(1.0);
    }

    public String getCoords(double d) {
        if (DotMaker2.isJunit() && this.visible.getCoords(1.0).contains("0,0,0,0")) {
            throw new IllegalStateException();
        }
        return this.visible.getCoords(d);
    }

    public void setMember(boolean bl) {
        this.member = bl;
    }

    public final boolean isMember() {
        return this.member;
    }

    public void ensureVisible(double d, double d2) {
        this.visible.ensureVisible(d, d2);
    }
}

