/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealMax;
import net.sourceforge.plantuml.real.RealMin;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxFinder;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import net.sourceforge.plantuml.sequencediagram.teoz.TileBuilder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupingTile
implements Tile {
    private final List<Tile> tiles = new ArrayList<Tile>();
    private final RealMin min = new RealMin();
    private final RealMax max = new RealMax();
    private final GroupingStart start;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Display display;
    private double bodyHeight;

    @Override
    public Event getEvent() {
        return this.start;
    }

    public GroupingTile(Iterator<Event> iterator, GroupingStart groupingStart, TileArguments tileArguments) {
        Object object;
        StringBounder stringBounder = tileArguments.getStringBounder();
        this.start = groupingStart;
        this.display = groupingStart.getTitle().equals("group") ? Display.create(groupingStart.getComment()) : Display.create(groupingStart.getTitle(), groupingStart.getComment());
        this.skin = tileArguments.getSkin();
        this.skinParam = tileArguments.getSkinParam();
        while (iterator.hasNext()) {
            object = iterator.next();
            System.err.println("GroupingTile::ev=" + object);
            if (object instanceof GroupingLeaf && ((Grouping)object).getType() == GroupingType.END) break;
            Tile tile = TileBuilder.buildOne(iterator, tileArguments, (Event)object, this);
            if (tile == null) continue;
            this.tiles.add(tile);
            this.min.put(tile.getMinX(stringBounder));
            this.max.put(tile.getMaxX(stringBounder));
            this.bodyHeight += tile.getPreferredHeight(stringBounder);
        }
        object = this.getPreferredDimensionIfEmpty(stringBounder);
        double d = ((Dimension2D)object).getWidth();
        System.err.println("width=" + d);
        if (this.min.size() == 0) {
            this.min.put(tileArguments.getOrigin());
            this.max.put(tileArguments.getOmega());
        }
        this.max.ensureBiggerThan(this.getMinX(stringBounder).addFixed(d));
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.GROUPING_HEADER, null, this.skinParam, this.display);
        return component;
    }

    public Dimension2D getPreferredDimensionIfEmpty(StringBounder stringBounder) {
        return this.getComponent(stringBounder).getPreferredDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        Area area = new Area(this.max.getCurrentValue() - this.min.getCurrentValue(), this.bodyHeight + dimension2D.getHeight());
        if (!(uGraphic instanceof LiveBoxFinder)) {
            component.drawU(uGraphic.apply(new UTranslate(this.min.getCurrentValue(), 0.0)), area, new SimpleContext2D(false));
        }
        double d = dimension2D.getHeight();
        for (Tile tile : this.tiles) {
            uGraphic.apply(new UTranslate(0.0, d)).draw(tile);
            d += tile.getPreferredHeight(stringBounder);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getPreferredDimensionIfEmpty(stringBounder);
        return dimension2D.getHeight() + this.bodyHeight;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        return this.min;
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        return this.max;
    }
}

