/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.List;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsHistory {
    private final Participant p;
    private final List<Event> events;

    public EventsHistory(Participant participant, List<Event> list) {
        this.p = participant;
        this.events = list;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public int getLevelAt(Event event) {
        int n = this.p.getInitialLife();
        for (Event event2 : this.events) {
            if (event2 instanceof Message) {
                Message message = (Message)event2;
                for (LifeEvent lifeEvent : message.getLiveEvents()) {
                    if (lifeEvent.getParticipant() == this.p && lifeEvent.getType() == LifeEventType.ACTIVATE) {
                        ++n;
                    }
                    if (lifeEvent.getParticipant() != this.p || lifeEvent.getType() != LifeEventType.DEACTIVATE) continue;
                    --n;
                }
            }
            if (event != event2) continue;
            return n;
        }
        return n;
    }

    private int getLevelAtOld(Event event) {
        int n = this.p.getInitialLife();
        for (Event event2 : this.events) {
            Message message;
            if (event2 instanceof Message) {
                message = (Message)event2;
                for (LifeEvent lifeEvent : message.getLiveEvents()) {
                    if (lifeEvent.getParticipant() != this.p || lifeEvent.getType() != LifeEventType.ACTIVATE) continue;
                    ++n;
                }
            }
            if (event == event2) {
                return n;
            }
            if (!(event2 instanceof Message)) continue;
            message = (Message)event2;
            for (LifeEvent lifeEvent : message.getLiveEvents()) {
                if (lifeEvent.getParticipant() != this.p || lifeEvent.getType() != LifeEventType.DEACTIVATE) continue;
                --n;
            }
        }
        return n;
    }
}

