/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomText;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;

public class AtomImg
implements Atom {
    private final BufferedImage image;

    private AtomImg(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public static Atom create(String string, ImgValign imgValign, int n) {
        UFont uFont = new UFont("Monospaced", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE);
        try {
            File file = FileSystem.getInstance().getFile(string);
            if (!file.exists()) {
                if (string.startsWith("http:") || string.startsWith("https:")) {
                    byte[] byArray = AtomImg.getFile(string);
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    if (bufferedImage == null) {
                        return AtomText.create("(Cannot decode: " + string + ")", fontConfiguration);
                    }
                    return new AtomImg(bufferedImage);
                }
                return AtomText.create("(File not found: " + file + ")", fontConfiguration);
            }
            if (file.getName().endsWith(".svg")) {
                throw new UnsupportedOperationException();
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return AtomText.create("(Cannot decode: " + file + ")", fontConfiguration);
            }
            return new AtomImg(ImageIO.read(file));
        }
        catch (IOException iOException) {
            return AtomText.create("ERROR " + iOException.toString(), fontConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String string) throws IOException {
        byte[] byArray;
        block3: {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = null;
            try {
                int n;
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
                byte[] byArray2 = new byte[1024];
                while ((n = inputStream.read(byArray2)) > 0) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
                Object var9_8 = null;
                if (inputStream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var9_9 = null;
                    if (inputStream == null) break block4;
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        return byArray;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.image.getWidth(), this.image.getHeight());
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic.draw(new UImage(this.image));
    }
}

