/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActiveLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseActor;
import net.sourceforge.plantuml.skin.rose.ComponentRoseArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseBoundary;
import net.sourceforge.plantuml.skin.rose.ComponentRoseControl;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDatabase;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDelayText;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDestroy;
import net.sourceforge.plantuml.skin.rose.ComponentRoseDivider;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEnglober;
import net.sourceforge.plantuml.skin.rose.ComponentRoseEntity;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingElse;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingHeader;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;
import net.sourceforge.plantuml.skin.rose.ComponentRoseLine;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNewpage;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNote;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteBox;
import net.sourceforge.plantuml.skin.rose.ComponentRoseNoteHexagonal;
import net.sourceforge.plantuml.skin.rose.ComponentRoseParticipant;
import net.sourceforge.plantuml.skin.rose.ComponentRoseReference;
import net.sourceforge.plantuml.skin.rose.ComponentRoseSelfArrow;
import net.sourceforge.plantuml.skin.rose.ComponentRoseTitle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class Rose
implements Skin {
    private final double paddingX = 5.0;
    private final double paddingY = 5.0;

    public HtmlColor getFontColor(ISkinParam iSkinParam, FontParam fontParam) {
        return iSkinParam.getFontHtmlColor(fontParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam) {
        return this.getHtmlColor(iSkinParam, colorParam, null);
    }

    public HtmlColor getHtmlColor(ISkinParam iSkinParam, ColorParam colorParam, Stereotype stereotype) {
        HtmlColor htmlColor = iSkinParam.getHtmlColor(colorParam, stereotype, false);
        if (htmlColor == null && (htmlColor = colorParam.getDefaultValue()) == null) {
            throw new IllegalArgumentException();
        }
        return htmlColor;
    }

    public Component createComponent(ComponentType componentType, ArrowConfiguration arrowConfiguration, ISkinParam iSkinParam, Display display) {
        double d;
        HtmlColor htmlColor = iSkinParam.getBackgroundColor();
        HtmlColor htmlColor2 = iSkinParam.getHyperlinkColor();
        HtmlColor htmlColor3 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBorder);
        HtmlColor htmlColor4 = this.getHtmlColor(iSkinParam, ColorParam.sequenceGroupBackground);
        HtmlColor htmlColor5 = this.getHtmlColor(iSkinParam, ColorParam.sequenceDividerBackground);
        HtmlColor htmlColor6 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBackground);
        HtmlColor htmlColor7 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceHeaderBackground);
        HtmlColor htmlColor8 = this.getHtmlColor(iSkinParam, ColorParam.sequenceReferenceBorder);
        HtmlColor htmlColor9 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBackground);
        HtmlColor htmlColor10 = this.getHtmlColor(iSkinParam, ColorParam.actorBackground);
        HtmlColor htmlColor11 = this.getHtmlColor(iSkinParam, ColorParam.participantBackground);
        UFont uFont = iSkinParam.getFont(FontParam.SEQUENCE_ARROW, null);
        UFont uFont2 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP, null);
        UFont uFont3 = iSkinParam.getFont(FontParam.PARTICIPANT, null);
        UFont uFont4 = iSkinParam.getFont(FontParam.ACTOR, null);
        double d2 = d = iSkinParam.shadowing() ? 4.0 : 0.0;
        if (componentType.isArrow()) {
            HtmlColor htmlColor12;
            HtmlColor htmlColor13 = htmlColor12 = arrowConfiguration.getColor() == null ? this.getHtmlColor(iSkinParam, ColorParam.sequenceArrow) : arrowConfiguration.getColor();
            if (arrowConfiguration.getArrowDirection() == ArrowDirection.SELF) {
                return new ComponentRoseSelfArrow(htmlColor12, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), htmlColor2, uFont, display, arrowConfiguration, (ISkinSimple)iSkinParam, iSkinParam.maxMessageSize(), !iSkinParam.strictUmlStyle());
            }
            HorizontalAlignment horizontalAlignment = iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGE_ALIGN);
            HorizontalAlignment horizontalAlignment2 = iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_MESSAGETEXT_ALIGN);
            return new ComponentRoseArrow(htmlColor12, this.getFontColor(iSkinParam, FontParam.SEQUENCE_ARROW), htmlColor2, uFont, display, arrowConfiguration, horizontalAlignment, iSkinParam, horizontalAlignment2, iSkinParam.maxMessageSize(), !iSkinParam.strictUmlStyle());
        }
        if (componentType == ComponentType.PARTICIPANT_HEAD) {
            HtmlColor htmlColor14 = this.getHtmlColor(iSkinParam, ColorParam.participantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor14, this.getFontColor(iSkinParam, FontParam.PARTICIPANT), htmlColor2, uFont3, display, iSkinParam, d, iSkinParam.getRoundCorner(), Rose.getStroke(iSkinParam, LineParam.sequenceParticipantBorder, 1.5));
        }
        if (componentType == ComponentType.PARTICIPANT_TAIL) {
            HtmlColor htmlColor15 = this.getHtmlColor(iSkinParam, ColorParam.participantBorder);
            return new ComponentRoseParticipant(htmlColor11, htmlColor15, this.getFontColor(iSkinParam, FontParam.PARTICIPANT), htmlColor2, uFont3, display, iSkinParam, d, iSkinParam.getRoundCorner(), Rose.getStroke(iSkinParam, LineParam.sequenceParticipantBorder, 1.5));
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            HtmlColor htmlColor16 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor16, false, Rose.getStroke(iSkinParam, LineParam.sequenceLifeLineBorder, 1.0));
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            HtmlColor htmlColor17 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseLine(htmlColor17, true, Rose.getStroke(iSkinParam, LineParam.sequenceLifeLineBorder, 1.5));
        }
        if (componentType == ComponentType.ACTOR_HEAD) {
            HtmlColor htmlColor18 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor18, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, true, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.ACTOR_TAIL) {
            HtmlColor htmlColor19 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseActor(htmlColor10, htmlColor19, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, false, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.BOUNDARY_HEAD) {
            HtmlColor htmlColor20 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseBoundary(htmlColor10, htmlColor20, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, true, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.BOUNDARY_TAIL) {
            HtmlColor htmlColor21 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseBoundary(htmlColor10, htmlColor21, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, false, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.CONTROL_HEAD) {
            HtmlColor htmlColor22 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseControl(htmlColor10, htmlColor22, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, true, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.CONTROL_TAIL) {
            HtmlColor htmlColor23 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseControl(htmlColor10, htmlColor23, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, false, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.ENTITY_HEAD) {
            HtmlColor htmlColor24 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseEntity(htmlColor10, htmlColor24, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, true, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.ENTITY_TAIL) {
            HtmlColor htmlColor25 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseEntity(htmlColor10, htmlColor25, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, false, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.DATABASE_HEAD) {
            HtmlColor htmlColor26 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseDatabase(htmlColor10, htmlColor26, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, true, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.DATABASE_TAIL) {
            HtmlColor htmlColor27 = this.getHtmlColor(iSkinParam, ColorParam.actorBorder);
            return new ComponentRoseDatabase(htmlColor10, htmlColor27, this.getFontColor(iSkinParam, FontParam.ACTOR), htmlColor2, uFont4, display, false, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceActorBorder, 2.0));
        }
        if (componentType == ComponentType.NOTE) {
            HtmlColor htmlColor28 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor29 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont5 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNote(htmlColor28, htmlColor29, this.getFontColor(iSkinParam, FontParam.NOTE), htmlColor2, uFont5, display, 5.0, 5.0, (ISkinSimple)iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.noteBorder, 1.0));
        }
        if (componentType == ComponentType.NOTE_HEXAGONAL) {
            HtmlColor htmlColor30 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor31 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont6 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNoteHexagonal(htmlColor30, htmlColor31, this.getFontColor(iSkinParam, FontParam.NOTE), htmlColor2, uFont6, display, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.noteBorder, 1.0));
        }
        if (componentType == ComponentType.NOTE_BOX) {
            HtmlColor htmlColor32 = this.getHtmlColor(iSkinParam, ColorParam.noteBackground);
            HtmlColor htmlColor33 = this.getHtmlColor(iSkinParam, ColorParam.noteBorder);
            UFont uFont7 = iSkinParam.getFont(FontParam.NOTE, null);
            return new ComponentRoseNoteBox(htmlColor32, htmlColor33, this.getFontColor(iSkinParam, FontParam.NOTE), htmlColor2, uFont7, display, iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.noteBorder, 1.0));
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            UFont uFont8 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseGroupingHeader(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP_HEADER), htmlColor2, htmlColor, htmlColor4, htmlColor3, uFont8, uFont2, display, (ISkinSimple)iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceGroupBorder, 2.0));
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentRoseGroupingElse(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), htmlColor2, htmlColor3, uFont2, display.get(0), iSkinParam, htmlColor, Rose.getStroke(iSkinParam, LineParam.sequenceGroupBorder, 2.0));
        }
        if (componentType == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(7.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            HtmlColor htmlColor34 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor34, htmlColor9, true, true, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            HtmlColor htmlColor35 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor35, htmlColor9, true, false, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            HtmlColor htmlColor36 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor36, htmlColor9, false, true, d > 0.0);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            HtmlColor htmlColor37 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseActiveLine(htmlColor37, htmlColor9, false, false, d > 0.0);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            HtmlColor htmlColor38 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDelayLine(htmlColor38);
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentRoseDelayText(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DELAY), htmlColor2, iSkinParam.getFont(FontParam.SEQUENCE_DELAY, null), display, iSkinParam);
        }
        if (componentType == ComponentType.DESTROY) {
            HtmlColor htmlColor39 = this.getHtmlColor(iSkinParam, ColorParam.sequenceLifeLineBorder);
            return new ComponentRoseDestroy(htmlColor39);
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentRoseNewpage(this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP));
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentRoseDivider(this.getFontColor(iSkinParam, FontParam.SEQUENCE_DIVIDER), htmlColor2, iSkinParam.getFont(FontParam.SEQUENCE_DIVIDER, null), htmlColor5, display, iSkinParam, d > 0.0, Rose.getStroke(iSkinParam, LineParam.sequenceDividerBorder, 2.0));
        }
        if (componentType == ComponentType.REFERENCE) {
            UFont uFont9 = iSkinParam.getFont(FontParam.SEQUENCE_GROUP_HEADER, null);
            return new ComponentRoseReference(this.getFontColor(iSkinParam, FontParam.SEQUENCE_REFERENCE), htmlColor2, this.getFontColor(iSkinParam, FontParam.SEQUENCE_GROUP), iSkinParam.getFont(FontParam.SEQUENCE_REFERENCE, null), htmlColor8, htmlColor7, htmlColor6, uFont9, display, iSkinParam.getHorizontalAlignment(AlignParam.SEQUENCE_REFERENCE_ALIGN), iSkinParam, d, Rose.getStroke(iSkinParam, LineParam.sequenceReferenceBorder, 2.0));
        }
        if (componentType == ComponentType.TITLE) {
            return new ComponentRoseTitle(this.getFontColor(iSkinParam, FontParam.SEQUENCE_TITLE), htmlColor2, iSkinParam.getFont(FontParam.SEQUENCE_TITLE, null), display, iSkinParam);
        }
        if (componentType == ComponentType.SIGNATURE) {
            return new ComponentRoseTitle(HtmlColorUtils.BLACK, htmlColor2, uFont2, Display.create("This skin was created ", "in April 2009."), iSkinParam);
        }
        if (componentType == ComponentType.ENGLOBER) {
            HtmlColor htmlColor40 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBorder);
            HtmlColor htmlColor41 = this.getHtmlColor(iSkinParam, ColorParam.sequenceBoxBackground);
            return new ComponentRoseEnglober(htmlColor40, htmlColor41, display, this.getFontColor(iSkinParam, FontParam.SEQUENCE_BOX), htmlColor2, iSkinParam.getFont(FontParam.SEQUENCE_BOX, null), iSkinParam);
        }
        return null;
    }

    public static UStroke getStroke(ISkinParam iSkinParam, LineParam lineParam, double d) {
        UStroke uStroke = iSkinParam.getThickness(lineParam, null);
        if (uStroke == null) {
            return new UStroke(d);
        }
        return uStroke;
    }

    public Object getProtocolVersion() {
        return 1;
    }
}

