/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageLegend
implements TextBlock {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX = 6;
    private final int marginY = 5;
    private final boolean withShadow;
    private final TextBlock textBlock;

    private EntityImageLegend(Display display, ISkinParam iSkinParam) {
        this.withShadow = false;
        Rose rose = new Rose();
        this.noteBackgroundColor = rose.getHtmlColor(iSkinParam, ColorParam.legendBackground);
        this.borderColor = rose.getHtmlColor(iSkinParam, ColorParam.legendBorder);
        HtmlColor htmlColor = rose.getFontColor(iSkinParam, FontParam.LEGEND);
        UFont uFont = iSkinParam.getFont(FontParam.LEGEND, null);
        this.textBlock = TextBlockUtils.create(display, new FontConfiguration(uFont, htmlColor, iSkinParam.getHyperlinkColor()), HorizontalAlignment.LEFT, iSkinParam);
    }

    public static TextBlock create(Display display, ISkinParam iSkinParam) {
        return TextBlockUtils.withMargin(new EntityImageLegend(display, iSkinParam), 8.0, 8.0);
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 10.0;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 12.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getTextHeight(stringBounder);
        double d2 = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(d2 + 1.0, d + 1.0);
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        uGraphic.draw(uPolygon);
        this.textBlock.drawU(uGraphic.apply(new UTranslate(6.0, 5.0)));
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        double d = this.getTextWidth(stringBounder);
        uPolygon.addPoint(d, this.getTextHeight(stringBounder));
        uPolygon.addPoint(d, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }
}

