/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CollisionDetector
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final Context context;

    public UGraphic apply(UChange uChange) {
        if (uChange instanceof UTranslate) {
            return new CollisionDetector(this.stringBounder, this.translate.compose((UTranslate)uChange), this.context);
        }
        if (uChange instanceof UStroke) {
            return new CollisionDetector(this);
        }
        if (uChange instanceof UChangeBackColor) {
            return new CollisionDetector(this);
        }
        if (uChange instanceof UChangeColor) {
            return new CollisionDetector(this);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean collisionCheck(MinMax minMax, Line2D line2D) {
        if (line2D.getY1() != line2D.getY2()) {
            throw new IllegalArgumentException();
        }
        if (line2D.getY1() < minMax.getMinY()) {
            return false;
        }
        if (line2D.getY1() > minMax.getMaxY()) {
            return false;
        }
        double d = Math.min(line2D.getX1(), line2D.getX2());
        double d2 = Math.max(line2D.getX1(), line2D.getX2());
        if (d2 < minMax.getMinX()) {
            return false;
        }
        return !(d > minMax.getMaxX());
    }

    public CollisionDetector(StringBounder stringBounder) {
        this(stringBounder, new UTranslate(), new Context());
    }

    private CollisionDetector(StringBounder stringBounder, UTranslate uTranslate, Context context) {
        this.stringBounder = stringBounder;
        this.translate = uTranslate;
        this.context = context;
    }

    private CollisionDetector(CollisionDetector collisionDetector) {
        this(collisionDetector.stringBounder, collisionDetector.translate, collisionDetector.context);
    }

    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public UParam getParam() {
        return new UParamNull();
    }

    public void draw(UShape uShape) {
        if (uShape instanceof UPolygon) {
            this.drawPolygone((UPolygon)uShape);
        } else if (uShape instanceof URectangle) {
            this.drawRectangle((URectangle)uShape);
        } else if (uShape instanceof Snake) {
            this.drawSnake((Snake)uShape);
        }
    }

    private void drawSnake(Snake snake) {
        if (this.context.manageSnakes) {
            this.context.snakes.add(snake.translate(this.translate));
        }
    }

    private void drawRectangle(URectangle uRectangle) {
        this.context.rectangles.add(uRectangle.getMinMax().translate(this.translate));
    }

    private void drawPolygone(UPolygon uPolygon) {
        this.context.rectangles.add(uPolygon.getMinMax().translate(this.translate));
    }

    public ColorMapper getColorMapper() {
        throw new UnsupportedOperationException();
    }

    public void startUrl(Url url) {
    }

    public void closeAction() {
    }

    public void flushUg() {
    }

    public void drawDebug(UGraphic uGraphic) {
        this.context.drawDebug(uGraphic);
    }

    public final void setManageSnakes(boolean bl) {
        this.context.manageSnakes = bl;
    }

    public boolean isSpecialTxt() {
        return false;
    }

    static class Context {
        private final List<MinMax> rectangles = new ArrayList<MinMax>();
        private final List<Snake> snakes = new ArrayList<Snake>();
        private boolean manageSnakes;

        Context() {
        }

        public void drawDebug(UGraphic uGraphic) {
            for (MinMax object : this.rectangles) {
                if (!this.collision(object)) continue;
                object.drawGrey(uGraphic);
            }
            HtmlColor htmlColor = HtmlColorUtils.BLACK;
            uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UStroke(5.0));
            for (Snake snake : this.snakes) {
                for (Line2D line2D : snake.getHorizontalLines()) {
                    if (!this.collision(line2D)) continue;
                    this.drawLine(uGraphic, line2D);
                }
            }
        }

        private void drawLine(UGraphic uGraphic, Line2D line2D) {
            uGraphic = uGraphic.apply(new UTranslate(line2D.getX1(), line2D.getY1()));
            uGraphic.draw(new ULine(line2D.getX2() - line2D.getX1(), line2D.getY2() - line2D.getY1()));
        }

        private boolean collision(Line2D line2D) {
            for (MinMax minMax : this.rectangles) {
                if (!CollisionDetector.collisionCheck(minMax, line2D)) continue;
                return true;
            }
            return false;
        }

        private boolean collision(MinMax minMax) {
            for (Snake snake : this.snakes) {
                for (Line2D line2D : snake.getHorizontalLines()) {
                    if (!CollisionDetector.collisionCheck(minMax, line2D)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

