/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import net.sourceforge.plantuml.fun.IconLoader;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.QuoteUtils;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.pdf.PdfConverter;
import net.sourceforge.plantuml.svek.EmptySvgException;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagram
extends AbstractPSystem
implements Diagram {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private Display title;
    private Display header;
    private Display footer;
    private Display legend = null;
    private HorizontalAlignment legendAlignment = HorizontalAlignment.CENTER;
    private HorizontalAlignment headerAlignment = HorizontalAlignment.RIGHT;
    private HorizontalAlignment footerAlignment = HorizontalAlignment.CENTER;
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private final SkinParam skinParam = new SkinParam(this.getUmlDiagramType());
    private Dimension2D lastInfo;

    public final void setTitle(Display display) {
        this.title = display;
    }

    @Override
    public final Display getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int n) {
        this.minwidth = n;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean bl) {
        this.rotation = bl;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String string, String string2) {
        this.skinParam.setParam(string.toLowerCase(), string2);
    }

    public final Display getHeader() {
        return this.header;
    }

    public final void setHeader(Display display) {
        this.header = display;
    }

    public final Display getFooter() {
        return this.footer;
    }

    public final void setFooter(Display display) {
        this.footer = display;
    }

    public final HorizontalAlignment getHeaderAlignment() {
        return this.headerAlignment;
    }

    public final void setHeaderAlignment(HorizontalAlignment horizontalAlignment) {
        this.headerAlignment = horizontalAlignment;
    }

    public final HorizontalAlignment getFooterAlignment() {
        return this.footerAlignment;
    }

    public final void setFooterAlignment(HorizontalAlignment horizontalAlignment) {
        this.footerAlignment = horizontalAlignment;
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean bl) {
        this.hideUnlinkedData = bl;
    }

    @Override
    public final ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        Object object;
        List<BufferedImage> list = null;
        try {
            if ("split".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                object = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportSplitCompress((String)object);
            } else if ("compress".equalsIgnoreCase(this.getSkinParam().getValue("flashcode")) && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                object = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportFlashcodeCompress((String)object);
            } else if (this.getSkinParam().getValue("flashcode") != null && fileFormatOption.getFileFormat() == FileFormat.PNG) {
                object = this.getSource().getPlainString();
                list = this.getFlashCodeUtils().exportFlashcodeSimple((String)object);
            }
        }
        catch (IOException iOException) {
            Log.error("Cannot generate flashcode");
            iOException.printStackTrace();
            list = null;
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(outputStream, n, list);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.MJPEG) {
            throw new UnsupportedOperationException();
        }
        try {
            object = this.exportDiagramInternal(outputStream, n, fileFormatOption, list);
            this.lastInfo = new Dimension2DDouble(object.getWidth(), object.getHeight());
            return object;
        }
        catch (UnparsableGraphvizException unparsableGraphvizException) {
            unparsableGraphvizException.printStackTrace();
            this.exportDiagramError(outputStream, unparsableGraphvizException.getCause(), fileFormatOption, unparsableGraphvizException.getGraphvizVersion(), unparsableGraphvizException.getDebugData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exportDiagramError(outputStream, exception, fileFormatOption, null, null);
        }
        return new ImageDataSimple();
    }

    private void exportDiagramError(OutputStream outputStream, Throwable throwable, FileFormatOption fileFormatOption, String string, String string2) throws IOException {
        UFont uFont = new UFont("SansSerif", 0, 12);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("An error has occured : " + throwable);
        String string3 = QuoteUtils.getSomeQuote();
        arrayList.add("<i>" + string3);
        arrayList.add(" ");
        arrayList.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (throwable instanceof EmptySvgException) {
            arrayList.add("Because dot/GraphViz returns an empty string.");
        }
        if (string != null) {
            arrayList.add(" ");
            arrayList.add("GraphViz version used : " + string);
        }
        arrayList.add(" ");
        arrayList.add("This may be caused by :");
        arrayList.add(" - a bug in PlantUML");
        arrayList.add(" - a problem in GraphViz");
        arrayList.add(" ");
        arrayList.add("You should send this diagram and this image to <b>plantuml@gmail.com</b> to solve this issue.");
        arrayList.add("You can try to turn arround this issue by simplifing your diagram.");
        arrayList.add(" ");
        arrayList.add(throwable.toString());
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            arrayList.add("  " + stackTraceElement.toString());
        }
        GraphicStrings graphicStrings = new GraphicStrings(arrayList, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        graphicStrings.writeImage(outputStream, fileFormatOption, string2);
    }

    private FlashCodeUtils getFlashCodeUtils() {
        return FlashCodeFactory.getFlashCodeUtils();
    }

    private void exportDiagramInternalMjpeg(OutputStream outputStream) throws IOException {
        File file = new File("c:/test.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            double d = (double)(149 - i) * 1.0 / 150.0;
            affineTransform.setToShear(d, d);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.close();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            mJPEGGenerator.addImage(bufferedImage);
        }
        mJPEGGenerator.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream outputStream, int n, List<BufferedImage> list) throws IOException {
        File file = FileUtils.createTempFile("pdf", ".svf");
        File file2 = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ImageData imageData = this.exportDiagram(bufferedOutputStream, n, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)bufferedOutputStream).close();
        PdfConverter.convert(file, file2);
        FileUtils.copyToStream(file2, outputStream);
        return imageData;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3, List<BufferedImage> var4) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(File file, ImageData imageData) throws FileNotFoundException {
        String string = UmlDiagram.changeName(file.getAbsolutePath());
        File file2 = new File(string);
        PrintWriter printWriter = null;
        try {
            if (!PSystemUtils.canFileBeWritten(file2)) {
                Object var7_6 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                return;
            }
            printWriter = new PrintWriter(file2);
            printWriter.print(imageData.getCMapData(file2.getName().substring(0, file2.getName().length() - 6)));
            printWriter.close();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        Object var7_7 = null;
        if (printWriter != null) {
            printWriter.close();
        }
    }

    static String changeName(String string) {
        return string.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double d = this.lastInfo.getWidth();
        if (d == 0.0) {
            return null;
        }
        String string = this.getSkinParam().getValue("widthwarning");
        if (string == null) {
            return null;
        }
        if (!string.matches("\\d+")) {
            return null;
        }
        int n = Integer.parseInt(string);
        if (d > (double)n) {
            return "The image is " + (int)d + " pixel width. (Warning limit is " + n + ")";
        }
        return null;
    }

    public void addSprite(String string, Sprite sprite) {
        this.skinParam.addSprite(string, sprite);
    }

    public final Display getLegend() {
        return this.legend;
    }

    public final HorizontalAlignment getLegendAlignment() {
        return this.legendAlignment;
    }

    public final void setLegend(Display display, HorizontalAlignment horizontalAlignment) {
        this.legend = display;
        this.legendAlignment = horizontalAlignment;
    }
}

