package de.viaboxx.markdown;

/**
 * class Confluence2MD: convert a confluence Json page(s)/space to a markdown for pandoc
 * <pre>
 * Usage:
 * java -jar confluence2md-fat.jar -m wiki &lt;pageId&gt;  &gt; [outputfile]
 * java -jar confluence2md-fat.jar -m file &lt;input file&gt;  &gt; [outputfile]
 * java -jar confluence2md-fat.jar -m url  &lt;input URL&gt;   &gt; [outputfile]
 *
 * options:
 * -m wiki|file|url specify input format/processing mode (default: wiki)
 * -o file specify output format, charset=UTF-8  (default: stdout, charset=file.encoding of plaform)
 * -oa file specify output format, charset=UTF-8 - open for append!
 * -v true for verbose output       (default: false)
 * -u user:password to use HTTP-Basic-Auth to request the URL (default: no auth)
 * -depth -1..n the depth to follow down the child-pages hierarchy. -1=infinte, 0=no children (default: -1)
 * -server URL of confluence server. used in wiki-mode (default: https://viaboxx.atlassian.net/wiki)
 * -plantuml  turn off integrated run of PlantUML to render diagrams (default is to call PlantUML automatically)
 * -a download folder for attachments (default: attachments)
 * last parameter: the file to read (-m file) or the URL to get (-m url) or the pageId to start with (-m wiki)
 * +H true/false true: document hierarchy used to generate page header format type (child document => h2 etc) (default: true)
 * +T true/false true: title transformation ON (cut everything before first -) (default: true)
 * +RootPageTitle true/false true: generate header for root page, false: omit header of root page (default: true)
 * </pre>
 */
public class Confluence2MD_doc {
    /**
     * calls Confluence2MD.main(args);
     *
     * @param args
     */
    public static void main(String[] args) {
        Confluence2MD.main(args);
    }
}
