/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.nagios;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.googlecode.jsendnsca.builders.NagiosSettingsBuilder;
import com.googlecode.jsendnsca.encryption.Encryption;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.MDC;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NagiosAppender
extends AppenderSkeleton {
    public static final String MONITORED_SERVICE_NAME = "monitoredServiceName";
    public static final String MONITORED_HOST_NAME = "monitoredHostName";
    private NagiosPassiveCheckSender sender;
    private String nagiosServiceName;
    private String nagiosHost;
    private String nagiosEncryption;
    private String nagiosPassword;
    private int nagiosPort = 5667;
    private String monitoredHostName;
    private String monitoredServiceName;
    private String monitorWarnAs = "WARNING";
    private String monitorErrorAs = "CRITICAL";
    private String monitorFatalAs = "CRITICAL";
    private boolean resetStateAfterCritical = false;
    private boolean resetStateAfterWarning = false;

    protected void append(LoggingEvent event) {
        Level nagiosLevel = this.nagiosLevel(event);
        if (nagiosLevel != null) {
            this.sendEventWithLevel(this.renderMsg(event), nagiosLevel);
            if (this.resetStateAfterCritical && nagiosLevel.equals((Object)Level.CRITICAL)) {
                this.sendEventWithLevel("Reset after CRITICAL: " + event.getRenderedMessage(), Level.OK);
            }
            if (this.resetStateAfterWarning && nagiosLevel.equals((Object)Level.WARNING)) {
                this.sendEventWithLevel("Reset after WARNING: " + event.getRenderedMessage(), Level.OK);
            }
        }
    }

    private String renderMsg(LoggingEvent event) {
        return "[" + event.getLoggerName() + "] " + event.getRenderedMessage();
    }

    private void sendEventWithLevel(String message, Level nagiosLevel) {
        MessagePayload payload = new MessagePayloadBuilder().withHostname(this.findHostName()).withServiceName(this.findServiceName()).withLevel(nagiosLevel).withMessage(message).create();
        try {
            this.sender.send(payload);
        }
        catch (NagiosException e) {
            LogLog.error((String)("Nagios Exception=" + e.getMessage()));
        }
        catch (IOException e) {
            LogLog.error((String)("IOException=" + e.getMessage()));
        }
    }

    private Level nagiosLevel(LoggingEvent event) {
        if (event.getLevel().equals((Object)org.apache.log4j.Level.WARN)) {
            return Level.valueOf((String)this.monitorWarnAs);
        }
        if (event.getLevel().equals((Object)org.apache.log4j.Level.ERROR)) {
            return Level.valueOf((String)this.monitorErrorAs);
        }
        if (event.getLevel().equals((Object)org.apache.log4j.Level.FATAL)) {
            return Level.valueOf((String)this.monitorFatalAs);
        }
        return null;
    }

    private String findServiceName() {
        String serviceNameFromMDC = (String)MDC.get((String)MONITORED_SERVICE_NAME);
        String serviceName = this.monitoredServiceName != null && !this.monitoredServiceName.isEmpty() ? this.monitoredServiceName : (serviceNameFromMDC != null && !serviceNameFromMDC.isEmpty() ? serviceNameFromMDC : "SERVICE_NAME_NOT_SET");
        return serviceName;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public void activateOptions() {
        Encryption encryption = this.parseEncryption();
        NagiosSettings nagiosSettings = new NagiosSettingsBuilder().withNagiosHost(this.nagiosHost).withPort(this.nagiosPort).withEncryption(encryption).withPassword(this.nagiosPassword).create();
        this.sender = new NagiosPassiveCheckSender(nagiosSettings);
    }

    private String findHostName() {
        String hostName;
        String hostNameFromMDC = (String)MDC.get((String)MONITORED_HOST_NAME);
        if (this.monitoredHostName != null && !this.monitoredHostName.isEmpty()) {
            hostName = this.monitoredHostName;
        } else if (hostNameFromMDC != null && !hostNameFromMDC.isEmpty()) {
            hostName = hostNameFromMDC;
        } else {
            try {
                hostName = this.monitoredHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostName = "UNKNOWN_HOST_AND_NOT_CONFIGURED";
                LogLog.error((String)e.getMessage());
            }
        }
        return hostName;
    }

    private Encryption parseEncryption() {
        Encryption encryption;
        try {
            encryption = Encryption.valueOf((String)this.nagiosEncryption);
        }
        catch (IllegalArgumentException illegalArgument) {
            LogLog.error((String)("Unknown nagios encryption: " + this.nagiosEncryption + ". Using NONE by default."));
            encryption = Encryption.NONE;
        }
        return encryption;
    }

    public NagiosPassiveCheckSender getSender() {
        return this.sender;
    }

    public void setSender(NagiosPassiveCheckSender sender) {
        this.sender = sender;
    }

    public String getNagiosServiceName() {
        return this.nagiosServiceName;
    }

    public void setNagiosServiceName(String nagiosServiceName) {
        this.nagiosServiceName = nagiosServiceName;
    }

    public String getNagiosHost() {
        return this.nagiosHost;
    }

    public void setNagiosHost(String nagiosHost) {
        this.nagiosHost = nagiosHost;
    }

    public int getNagiosPort() {
        return this.nagiosPort;
    }

    public void setNagiosPort(int nagiosPort) {
        this.nagiosPort = nagiosPort;
    }

    public String getNagiosEncryption() {
        return this.nagiosEncryption;
    }

    public void setNagiosEncryption(String nagiosEncryption) {
        this.nagiosEncryption = nagiosEncryption;
    }

    public String getNagiosPassword() {
        return this.nagiosPassword;
    }

    public void setNagiosPassword(String nagiosPassword) {
        this.nagiosPassword = nagiosPassword;
    }

    public String getMonitoredServiceName() {
        return this.monitoredServiceName;
    }

    public void setMonitoredServiceName(String monitoredServiceName) {
        this.monitoredServiceName = monitoredServiceName;
    }

    public String getMonitoredHostName() {
        return this.monitoredHostName;
    }

    public void setMonitoredHostName(String monitoredHostName) {
        this.monitoredHostName = monitoredHostName;
    }

    public String getMonitorWarnAs() {
        return this.monitorWarnAs;
    }

    public void setMonitorWarnAs(String monitorWarnAs) {
        this.monitorWarnAs = monitorWarnAs;
    }

    public String getMonitorErrorAs() {
        return this.monitorErrorAs;
    }

    public void setMonitorErrorAs(String monitorErrorAs) {
        this.monitorErrorAs = monitorErrorAs;
    }

    public String getMonitorFatalAs() {
        return this.monitorFatalAs;
    }

    public void setMonitorFatalAs(String monitorFatalAs) {
        this.monitorFatalAs = monitorFatalAs;
    }

    public boolean isResetStateAfterCritical() {
        return this.resetStateAfterCritical;
    }

    public void setResetStateAfterCritical(boolean resetStateAfterCritical) {
        this.resetStateAfterCritical = resetStateAfterCritical;
    }

    public boolean isResetStateAfterWarning() {
        return this.resetStateAfterWarning;
    }

    public void setResetStateAfterWarning(boolean resetStateAfterWarning) {
        this.resetStateAfterWarning = resetStateAfterWarning;
    }
}

