/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.mojo.jruby;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

public class JRubyGemsMojo
extends AbstractMojo {
    public static final String BUNDLER_GEM_PATH = "gems/bundler-1.1.3/lib";
    private File buildDirectory;
    private File baseDirectory;
    private MavenProject project;
    protected MavenSession session;
    private static FilenameFilter dirsOnlyFilter = new FilenameFilter(){

        @Override
        public boolean accept(File file, String s) {
            return file.isDirectory();
        }
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.session.getSettings().isOffline()) {
            this.getLog().warn((CharSequence)"Executed in offline mode => No Gems will be fetched!");
            return;
        }
        try {
            this.getLog().info((CharSequence)"Downloading gems found in Gemfile...");
            this.fetchGems();
            this.moveGems();
            this.getLog().info((CharSequence)"Preparing gem lookup file");
            this.prepareGems();
            this.cleanup();
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void cleanup() throws IOException {
        FileUtils.cleanDirectory((File)new File(this.buildDirectory, "bundled-gems"));
    }

    private void moveGems() throws IOException {
        File gemsInJar = new File(this.buildDirectory, "bundled-gems/jruby/1.8/gems");
        FileUtils.copyDirectoryToDirectory((File)gemsInJar, (File)new File(this.buildDirectory, "generated-resources"));
    }

    private void prepareGems() throws IOException {
        File gemsInJar = new File(this.buildDirectory, "generated-resources/gems-in-jar");
        FileUtils.forceMkdir((File)gemsInJar);
        File gemsSpec = new File(gemsInJar, "gems-in-jar.properties");
        this.createGemSpec(gemsSpec);
    }

    private void createGemSpec(File gemsSpec) throws IOException {
        Properties properties = this.createGemSpecProperties();
        gemsSpec.createNewFile();
        properties.store(new FileWriter(gemsSpec), "Gems for " + this.project.getArtifact().toString());
    }

    private Properties createGemSpecProperties() {
        String[] gemDirs;
        Properties properties = new Properties();
        File gems = new File(this.buildDirectory, "generated-resources/gems");
        for (String gemDir : gemDirs = gems.list(dirsOnlyFilter)) {
            properties.put(this.bundleName(gemDir), gemDir);
        }
        return properties;
    }

    private String bundleName(String gemDir) {
        Pattern gemName = Pattern.compile("(.*)\\-\\d.*");
        Matcher matcher = gemName.matcher(gemDir);
        matcher.matches();
        return matcher.group(1);
    }

    private ScriptingContainer prepareRuntime() throws IOException, MojoExecutionException {
        ScriptingContainer container = new ScriptingContainer(LocalContextScope.THREADSAFE);
        ArrayList<String> loadPaths = new ArrayList<String>();
        URL bundler = ((Object)((Object)this)).getClass().getClassLoader().getResource(BUNDLER_GEM_PATH);
        if (bundler == null) {
            throw new MojoExecutionException("Cannot find bundler gem at 'gems/bundler-1.1.3/lib'");
        }
        loadPaths.add(bundler.getPath());
        this.getLog().info((CharSequence)("Using Bundler from " + bundler.getPath()));
        container.setLoadPaths(loadPaths);
        return container;
    }

    private void fetchGems() throws IOException, MojoExecutionException {
        ScriptingContainer container = this.prepareRuntime();
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("install_gems.rb");
        container.put("$gem_file_location", (Object)new File(this.project.getFile().getParentFile(), "Gemfile").getAbsolutePath());
        container.put("$base_dir", (Object)new File(this.project.getFile().getParentFile(), "target"));
        container.runScriptlet(resourceAsStream, "install_gems.rb");
    }
}

