/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.persistence;

import com.agimatec.dbhistory.HistSchemaConfig;
import com.agimatec.dbhistory.HistTableConfig;
import com.agimatec.dbtransform.CatalogConversion;
import com.agimatec.dbtransform.DataType;
import com.agimatec.dbtransform.DataTypeTransformation;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.SequenceDescription;
import com.agimatec.sql.meta.TableDescription;
import com.agimatec.sql.meta.persistence.ObjectPersistencer;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public class XStreamPersistencer
implements ObjectPersistencer {
    static final XStream xstream = new XStream();
    static Charset charset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Object obj, File target) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(target), charset);
        try {
            xstream.toXML(obj, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(File source) throws IOException, ClassNotFoundException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(source), charset);
        try {
            Object object = xstream.fromXML((Reader)reader);
            return object;
        }
        finally {
            reader.close();
        }
    }

    static {
        xstream.processAnnotations(HistSchemaConfig.class);
        xstream.processAnnotations(HistTableConfig.class);
        xstream.processAnnotations(CatalogDescription.class);
        xstream.processAnnotations(ColumnDescription.class);
        xstream.processAnnotations(ForeignKeyDescription.class);
        xstream.processAnnotations(IndexDescription.class);
        xstream.processAnnotations(SequenceDescription.class);
        xstream.processAnnotations(TableDescription.class);
        xstream.processAnnotations(CatalogConversion.class);
        xstream.processAnnotations(DataType.class);
        xstream.processAnnotations(DataTypeTransformation.class);
        charset = Charset.forName("UTF-8");
    }
}

