/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta;

import com.agimatec.sql.meta.A_IntegrityRuleDescription;
import com.agimatec.sql.meta.TableDescription;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="foreignKey")
public class ForeignKeyDescription
extends A_IntegrityRuleDescription {
    private String comment;
    private String constraintName;
    private String refTableName;
    private List<String> columns = new ArrayList<String>();
    private List<String> refColumns = new ArrayList<String>();
    private String onDeleteRule;

    public ForeignKeyDescription deepCopy() {
        try {
            ForeignKeyDescription clone = (ForeignKeyDescription)this.clone();
            clone.columns = new ArrayList<String>(this.columns);
            clone.refColumns = new ArrayList<String>(this.refColumns);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean isNullable(TableDescription aTable) {
        if (!aTable.getTableName().equalsIgnoreCase(this.getTableName())) {
            throw new IllegalArgumentException("Illegal table " + aTable + " for " + this);
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            String col = this.getColumn(i);
            if (aTable.getColumn(col).isNullable()) continue;
            return false;
        }
        return true;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String aConstraintName) {
        this.constraintName = aConstraintName;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public void setRefTableName(String aRefTableName) {
        this.refTableName = aRefTableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String aComment) {
        this.comment = aComment;
    }

    public int getColumn(String columnName) {
        for (int i = 0; i < this.columns.size(); ++i) {
            String col = this.columns.get(i);
            if (!col.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getRefColumn(String columnName) {
        for (int i = 0; i < this.refColumns.size(); ++i) {
            String col = this.refColumns.get(i);
            if (!col.equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumn(int i) {
        return this.columns.get(i);
    }

    public String getRefColumn(int i) {
        return this.refColumns.get(i);
    }

    @Override
    public int getColumnSize() {
        return this.columns.size();
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getRefColumns() {
        return this.refColumns;
    }

    public void addColumnPair(String column, String refColumn) {
        this.columns.add(column);
        this.refColumns.add(refColumn);
    }

    public String toString() {
        return this.getConstraintName();
    }

    public boolean containsColumn(String columnName) {
        for (String each : this.columns) {
            if (!each.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public void setOnDeleteRule(String string) {
        this.onDeleteRule = string;
    }

    public String getOnDeleteRule() {
        return this.onDeleteRule;
    }
}

