/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbtransform;

import com.agimatec.commons.generator.GeneratorTool;
import com.agimatec.dbtransform.CatalogConversion;
import com.agimatec.dbtransform.ScriptTransformator;
import com.agimatec.dbtransform.ScriptTransformatorSettings;
import com.agimatec.dbtransform.SomeDDLExpressions;
import com.agimatec.sql.meta.persistence.XStreamPersistencer;
import com.agimatec.sql.meta.script.DDLExpressions;
import com.agimatec.sql.script.SQLScriptParser;
import com.agimatec.sql.script.ScriptVisitor;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptTransformatorTool
extends GeneratorTool
implements FilenameFilter {
    private static final Log log = LogFactory.getLog(ScriptTransformatorTool.class);
    private CatalogConversion catalogConversion;

    protected Object getConfig() {
        return this.catalogConversion;
    }

    protected void readConfig(File configFile) throws IOException, ClassNotFoundException {
        if (configFile != null) {
            this.catalogConversion = (CatalogConversion)new XStreamPersistencer().load(configFile);
        }
    }

    public static void main(String[] args) throws Exception {
        ScriptTransformatorTool tool = new ScriptTransformatorTool();
        tool.runMain(args, new ScriptTransformatorSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMain(String[] args, ScriptTransformatorSettings settings) throws Exception {
        super.runMain(args, settings);
        DDLExpressions all = DDLExpressions.forDbms(settings.getFromDbms());
        if (all == null) {
            throw new IllegalArgumentException("unsupported source dbms: " + settings.getFromDbms());
        }
        SomeDDLExpressions expressions = new SomeDDLExpressions(all);
        expressions.addExpression("table-alter-columns");
        expressions.addExpression("drop-trigger");
        expressions.addExpression("dezign-create-table");
        expressions.addExpression("drop-table");
        expressions.addExpression("create-index");
        File fromDir = new File(settings.getFromDir());
        new File(settings.getTargetDir()).mkdirs();
        for (File fromFile : fromDir.listFiles(this)) {
            File targetFile = new File(settings.getTargetDir(), fromFile.getName());
            if (settings.isOverwrite() || !targetFile.exists()) {
                PrintWriter target = new PrintWriter(new FileWriter(targetFile));
                try {
                    SQLScriptParser parser = new SQLScriptParser(log);
                    ScriptTransformator transformator = new ScriptTransformator(expressions, target, this.catalogConversion, this.templateEngine);
                    parser.iterateSQLScript((ScriptVisitor)transformator, fromFile.toURI().toURL());
                    continue;
                }
                finally {
                    target.close();
                }
            }
            log.info((Object)("-overwrite=false, skipping overwrite of: " + targetFile.getPath()));
        }
    }

    protected ScriptTransformatorSettings getSettings() {
        return (ScriptTransformatorSettings)this.settings;
    }

    public boolean accept(File dir, String name) {
        return name.startsWith(this.getPrefix()) && name.endsWith(".sql");
    }

    public String getPrefix() {
        return this.getSettings().getPrefix();
    }
}

