/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.database;

import com.agimatec.database.AbstractDbTool;
import com.agimatec.database.DataSetFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;

public class DbUnitSetupTool
extends AbstractDbTool {
    protected static final Log log = LogFactory.getLog(DbUnitSetupTool.class);
    private String deleteDataFile = "delete_data.xml";
    private String operation = "INSERT";

    public String getDeleteDataFile() {
        return this.deleteDataFile;
    }

    public void setDeleteDataFile(String deleteDataFile) {
        this.deleteDataFile = deleteDataFile;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void execute() throws Exception {
        this.connectDbUnit();
        log.info((Object)("populating database from " + this.dataFile + " after deletion with " + this.deleteDataFile));
        if (this.deleteDataFile != null && this.deleteDataFile.length() > 0) {
            IDataSet deleteAllDataSet = DataSetFactory.createDataSet(this.deleteDataFile).load();
            DatabaseOperation.DELETE_ALL.execute(this.connection, deleteAllDataSet);
            DatabaseOperation.DELETE_ALL.execute(this.connection, deleteAllDataSet);
        }
        if (this.dataFile != null && this.dataFile.length() > 0) {
            IDataSet testDataSet = DataSetFactory.createDataSet(this.dataFile).load();
            if ("INSERT".equals(this.operation)) {
                DatabaseOperation.INSERT.execute(this.connection, testDataSet);
            } else if ("REFRESH".equals(this.operation)) {
                DatabaseOperation.REFRESH.execute(this.connection, testDataSet);
            } else if ("UPDATE".equals(this.operation)) {
                DatabaseOperation.UPDATE.execute(this.connection, testDataSet);
            } else {
                throw new UnsupportedOperationException("DatabaseOperation." + this.operation + " not supported.");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        DbUnitSetupTool setUp = new DbUnitSetupTool();
        if (!setUp.runMain(args)) {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runMain(String[] args) throws Exception {
        try {
            if (!this.parseArgs(args)) {
                boolean bl = false;
                return bl;
            }
            this.execute();
        }
        finally {
            this.disconnect();
        }
        return true;
    }

    protected boolean parseArgs(String[] args) {
        try {
            this.connectJdbc(args);
            for (int i = 4; i < args.length; ++i) {
                String each = args[i];
                if ("-i".equals(each)) {
                    this.setDataFile(args[++i]);
                    continue;
                }
                if (!"-d".equals(each)) continue;
                this.setDeleteDataFile(args[++i]);
            }
            return true;
        }
        catch (Exception ex) {
            this.printUsage();
            log.error((Object)"invalid parameters", (Throwable)ex);
            return false;
        }
    }

    protected void printUsage() {
        System.out.println("usage:\njava " + this.getClass().getName() + " {driver} {url} {user} {password} [-d {deleteDataFile}] [-i {insertDataFile}]");
    }
}

