/*
 * Decompiled with CFR 0.152.
 */
package de.viaboxx.dbmigrate.spring;

import com.agimatec.dbmigrate.AutoMigrationTool;
import de.viaboxx.dbmigrate.spring.DBCPAdapter;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBMigrateBean
implements InitializingBean,
BeanNameAware {
    private final AutoMigrationTool tool = new AutoMigrationTool();
    protected String beanName;
    protected DBCPAdapter dataSourceConfigurator;
    private boolean disabled = false;
    private boolean stopOnException = true;

    public void setConfigFile(String fileName) {
        this.getTool().setMigrateConfigFileName(fileName);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public void setSimulation(boolean sim) {
        this.getTool().setSim(sim);
    }

    public void setConfigRootUrl(String configRoot) {
        this.getTool().setConfigRootUrl(configRoot);
    }

    public void setToVersion(String version) {
        this.getTool().getEnvironment().put("to-version", version);
    }

    public void setFromVersion(String version) {
        this.getTool().getEnvironment().put("from-version", version);
    }

    public void setEnvironment(Map<String, Object> env) {
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            if (null != System.getProperty(entry.getKey())) continue;
            this.getTool().getEnvironment().put(entry.getKey(), entry.getValue());
        }
    }

    public void setMigrateConfig(Map<Object, Object> conf) {
        for (Map.Entry<Object, Object> entry : conf.entrySet()) {
            this.tool.getMigrateConfig().put(entry.getKey(), entry.getValue());
        }
    }

    public AutoMigrationTool getTool() {
        return this.tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.isDisabled()) {
            this.getTool().getLog().info((Object)(this.beanName + " - execution disabled!"));
            return;
        }
        try {
            this.getTool().getLog().info((Object)(this.beanName + " - initializing"));
            this.configure();
            this.getTool().setUp();
            this.getTool().startAutomaticMigration();
            this.getTool().getLog().info((Object)(this.beanName + " - successful"));
        }
        catch (Exception ex) {
            this.getTool().getLog().error((Object)(this.beanName + " - failed"), (Throwable)ex);
            if (this.isStopOnException()) {
                throw ex;
            }
        }
        finally {
            this.getTool().tearDown();
            this.getTool().getLog().info((Object)(this.beanName + " - finished"));
        }
    }

    private void configure() {
        if (this.dataSourceConfigurator != null) {
            this.dataSourceConfigurator.configure(this.getTool());
        }
        if (this.getTool().getMigrateConfig().get("Scripts-Prefix") == null) {
            this.getTool().getMigrateConfig().put("Scripts-Prefix", "up_");
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource != null) {
            this.dataSourceConfigurator = new DBCPAdapter();
            this.dataSourceConfigurator.setDataSource(dataSource);
        }
    }
}

