/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public class RevertableStringTokenizer
implements Enumeration {
    private List<String> tokens = new ArrayList<String>();
    private final StringTokenizer original;
    int position = -1;

    public RevertableStringTokenizer(StringTokenizer original) {
        this.original = original;
    }

    public boolean hasMoreElements() {
        return this.original.hasMoreElements();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.position < 0 || this.position >= this.tokens.size()) {
            this.position = -1;
            String next = this.original.nextToken();
            this.tokens.add(next);
            return next;
        }
        return this.tokens.get(this.position++);
    }

    public boolean hasMoreTokens() {
        return this.position >= 0 && this.position < this.tokens.size() || this.original.hasMoreTokens();
    }

    public int getPosition() {
        if (this.position < 0 || this.position >= this.tokens.size()) {
            return this.tokens.size();
        }
        return this.position;
    }

    public void setPosition(int index) {
        this.position = index;
    }
}

