/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import com.agimatec.sql.SQLStmtPreparer;
import com.agimatec.sql.SQLStringGenerator;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;

public class SQLStatement {
    private final List parameters;
    private final String sqlStatement;

    public SQLStatement(String stmtString) {
        this(stmtString, new ArrayList());
    }

    public SQLStatement(String stmtString, List params) {
        this.parameters = params;
        this.sqlStatement = stmtString;
    }

    public String getStatement() {
        return this.sqlStatement;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void addParameter(Object value) {
        this.parameters.add(value);
    }

    public PreparedStatement asPreparedStatement(Connection conn) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(this.sqlStatement);
        this.provideParameters(stmt);
        return stmt;
    }

    public void provideParameters(PreparedStatement stmt) throws SQLException {
        if (this.parameters.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.parameters.size()) {
            Object pval;
            if ((pval = this.parameters.get(i++)) == null) {
                stmt.setNull(i, 12);
                continue;
            }
            stmt.setObject(i, pval);
        }
    }

    public void logInfo(Log log) {
        if (log.isInfoEnabled()) {
            log.info((Object)this.getStatement());
            StringBuilder buf = new StringBuilder();
            buf.append("Params:");
            for (int i = 0; i < this.getParameters().size(); ++i) {
                String val = String.valueOf(this.getParameters().get(i));
                if (val.length() > 20) {
                    val = val.substring(0, 15) + "...";
                }
                buf.append(" <").append(val).append("> --");
            }
            log.info((Object)buf.toString());
        }
    }

    public String getParameterizedStatement() {
        try {
            StringWriter writer = new StringWriter();
            SQLStringGenerator sqlGen = new SQLStringGenerator(this.getStatement(), writer, this.getParameters());
            sqlGen.parse();
            return writer.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getParameterizedStatement() + "]";
    }

    public SQLStatement getPreparedStatement() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        try {
            StringWriter writer = new StringWriter();
            SQLStmtPreparer sqlGen = new SQLStmtPreparer(this.sqlStatement, writer, this.parameters);
            sqlGen.parse();
            return new SQLStatement(writer.toString(), sqlGen.getNewParams());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

