/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql;

import com.agimatec.sql.ReadStream;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;

public abstract class SQLClauseParserAbstract {
    private final Writer resultWriter;
    protected final ReadStream inputStream;
    private boolean expressionMode;
    protected int position;
    protected static final char INPUT_PARAM_INDICATOR = '?';
    protected static final char INPUT_TEXT_INDICATOR = '\'';
    protected static final char INPUT_BRACKET_OPEN = '(';
    protected static final char INPUT_BRACKET_CLOSE = ')';
    protected static final String RESULT_PARAM_INDICATOR = "?";

    protected SQLClauseParserAbstract(String input, Writer output) {
        this.inputStream = new ReadStream(input);
        this.resultWriter = output;
    }

    protected void addParseExpression(String aString) throws IOException {
        this.resultWriter.write(aString);
    }

    protected abstract void addParseParamExpression(String var1);

    protected abstract void addParseParamBracket(String var1) throws IOException;

    private void addParseText(String aString) throws IOException {
        this.resultWriter.write(aString);
    }

    private void foundExpression() {
        if (!this.expressionMode) {
            this.position = this.inputStream.position();
            this.expressionMode = true;
        }
    }

    protected void foundParamExpression() throws IOException {
        boolean cont;
        this.position = this.inputStream.position();
        do {
            char next;
            boolean bl = cont = !this.inputStream.atEnd();
            if (!cont || !this.isParamExpressionTerminator(next = this.inputStream.next())) continue;
            cont = false;
        } while (cont);
        int end = this.inputStream.position() + 1;
        if (this.position < end) {
            this.addParseParamExpression(this.inputStream.substring(this.position, end));
        }
    }

    protected void skip(int chars) {
        this.inputStream.skip(chars);
    }

    protected boolean isParamExpressionTerminator(char c) {
        return !Character.isLetterOrDigit(c);
    }

    protected void foundParamMarker() throws IOException, ParseException {
        this.handleExpression(false);
        if (this.inputStream.atEnd()) {
            this.signalUnexpectedToken("end of expression after ?");
        }
        this.position = this.inputStream.position();
        char next = this.inputStream.next();
        if (next == '?') {
            this.foundQuestionMark();
        } else if (next == '(') {
            this.foundParamOpenBracket();
        } else if (Character.isWhitespace(next)) {
            this.signalUnexpectedToken("blank after ?");
        } else {
            this.foundParamExpression();
        }
    }

    protected void foundParamOpenBracket() throws IOException, ParseException {
        this.position = this.inputStream.position() + 1;
        boolean cont = true;
        do {
            char next;
            if (this.inputStream.atEnd()) {
                this.signalMissingToken(String.valueOf(')'));
            }
            if ((next = this.inputStream.next()) != ')') continue;
            cont = false;
        } while (cont);
        int end = this.inputStream.position();
        if (this.position < end) {
            this.addParseParamBracket(this.inputStream.substring(this.position, end));
        }
    }

    private void foundQuestionMark() throws IOException {
        this.addParseExpression(RESULT_PARAM_INDICATOR);
    }

    private void foundTextDelimiter() throws ParseException, IOException {
        this.handleExpression(false);
        this.position = this.inputStream.position();
        int next = 0;
        while (!this.inputStream.atEnd()) {
            char c = this.inputStream.next();
            next = c;
            if (c != '\'') continue;
        }
        if (next != 39) {
            this.signalMissingToken("text delimiter");
        }
        int end = this.inputStream.position() + 1;
        this.addParseText(this.inputStream.substring(this.position, end));
    }

    protected final Writer getResultWriter() {
        return this.resultWriter;
    }

    protected void handleExpression(boolean atEnd) throws IOException {
        if (this.expressionMode) {
            int end;
            int n = end = atEnd ? this.inputStream.position() + 1 : this.inputStream.position();
            if (this.position <= end) {
                this.addParseExpression(this.inputStream.substring(this.position, end));
            }
        }
        this.expressionMode = false;
    }

    protected void initForParse() {
        this.expressionMode = false;
    }

    public void parse() throws IOException, ParseException {
        this.initForParse();
        block4: while (!this.inputStream.atEnd()) {
            char next = this.inputStream.next();
            switch (next) {
                case '\'': {
                    this.foundTextDelimiter();
                    continue block4;
                }
                case '?': {
                    this.foundParamMarker();
                    continue block4;
                }
            }
            this.foundExpression();
        }
        this.handleExpression(true);
    }

    protected void signalMissingToken(String aSyntaxElement) throws ParseException {
        throw new ParseException("Missing " + aSyntaxElement + " at " + this.inputStream.substring(this.position, this.inputStream.size()), this.position);
    }

    protected void signalUnexpectedToken(String aString) throws ParseException {
        throw new ParseException("Syntax error: Unexpected token " + aString + " at " + this.inputStream.substring(this.position, this.inputStream.size()), this.position);
    }
}

