/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.action;

import com.agimatec.dbmigrate.AutoMigrationTool;
import com.agimatec.dbmigrate.action.GroovyScriptAction;
import com.agimatec.dbmigrate.action.MigrateAction;
import com.agimatec.dbmigrate.action.SqlScriptAction;
import com.agimatec.dbmigrate.action.XmlScriptAction;

public abstract class ScriptAction
extends MigrateAction {
    protected String scriptName;

    public static ScriptAction create(AutoMigrationTool tool, String fileName, String fileType) {
        if ("xml".equalsIgnoreCase(fileType)) {
            return new XmlScriptAction(tool, fileName);
        }
        if ("sql".equalsIgnoreCase(fileType)) {
            return new SqlScriptAction(tool, fileName);
        }
        if ("groovy".equalsIgnoreCase(fileType)) {
            return new GroovyScriptAction(tool, fileName);
        }
        tool.log("not a supported file type: " + fileName);
        return null;
    }

    public static ScriptAction create(AutoMigrationTool tool, String fileName) {
        int idx = fileName.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        String fileType = fileName.substring(idx + 1);
        return ScriptAction.create(tool, fileName, fileType);
    }

    protected ScriptAction(AutoMigrationTool tool, String scriptName) {
        super(tool);
        this.scriptName = scriptName;
    }

    public String getScriptName() {
        return this.scriptName;
    }
}

