/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.database;

import com.agimatec.dbmigrate.MigrationTool;
import com.agimatec.dbmigrate.MigrationToolAware;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;

public abstract class AbstractDbTool
implements MigrationToolAware {
    protected Connection jdbcConnection;
    protected IDatabaseConnection connection;
    protected String dataFile = "data.xml";

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public void setJdbcConnection(Connection jdbcConnection) {
        this.jdbcConnection = jdbcConnection;
    }

    public IDatabaseConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IDatabaseConnection connection) {
        this.connection = connection;
    }

    public void setMigrationTool(MigrationTool tool) {
        this.jdbcConnection = tool.getTargetDatabase().getConnection();
    }

    protected void disconnect() throws Exception {
        if (this.jdbcConnection != null) {
            this.jdbcConnection.commit();
        }
        if (this.connection != null) {
            this.connection.getConnection().commit();
            this.connection.close();
            this.connection = null;
        }
    }

    protected void connectJdbc(String[] args) throws SQLException, ClassNotFoundException {
        this.connectJdbc(args[0], args[1], args[2], args[3]);
    }

    protected void connectJdbc(String driver, String url, String user, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        this.jdbcConnection = DriverManager.getConnection(url, user, password);
    }

    protected void connectDbUnit() throws SQLException, ClassNotFoundException {
        if (this.connection == null) {
            this.connection = new DatabaseConnection(this.jdbcConnection);
        }
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String insertDataFile) {
        this.dataFile = insertDataFile;
    }
}

