/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyReplacer {
    private static final Log myLogger = LogFactory.getLog(PropertyReplacer.class);
    private final Map myProperties;

    public PropertyReplacer(Map aProperties) {
        this.myProperties = aProperties;
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public String replaceProperties(String value, String chars) {
        if (chars == null || chars.length() == 0) {
            chars = "{}";
        }
        String beginChar = chars.substring(0, 1);
        String endChar = chars.substring(1, 2);
        if (value == null || value.length() == 0) {
            return value;
        }
        StringBuilder out = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(value, beginChar + endChar, true);
        boolean propMode = false;
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if (tok.equals(beginChar)) {
                if (propMode) {
                    out.append(beginChar);
                }
                propMode = !propMode;
                continue;
            }
            if (tok.equals(endChar)) {
                if (!propMode) {
                    out.append(endChar);
                    continue;
                }
                propMode = false;
                continue;
            }
            if (propMode) {
                if (this.getProperties().containsKey(tok)) {
                    out.append(this.getProperties().get(tok));
                    continue;
                }
                myLogger.warn((Object)("could not replace " + beginChar + tok + endChar + " - unknown property"));
                out.append(beginChar).append(tok).append(endChar);
                continue;
            }
            out.append(tok);
        }
        return out.toString();
    }

    public String replaceProperties(String value) {
        if (value == null) {
            return null;
        }
        ArrayList fragments = new ArrayList();
        ArrayList propertyRefs = new ArrayList();
        this.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder();
        Iterator i = fragments.iterator();
        Iterator j = propertyRefs.iterator();
        while (i.hasNext()) {
            Object fragment = i.next();
            if (fragment == null) {
                String propertyName = (String)j.next();
                fragment = this.getProperties().get(propertyName);
                if (fragment == null && myLogger.isWarnEnabled()) {
                    myLogger.warn((Object)("Property ${" + propertyName + "} has not been set"));
                }
                if (fragment == null) {
                    fragment = "${" + propertyName + '}';
                }
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private void parsePropertyString(String value, List fragments, List propertyRefs) {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new RuntimeException("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }
}

