/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.script;

import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SQLScriptExecutor
implements ScriptVisitor {
    private static final Log myLogger = LogFactory.getLog(SQLScriptExecutor.class);
    protected static final Log mySQLLogger = LogFactory.getLog((String)"commons.sql");
    private JdbcDatabase store;

    public SQLScriptExecutor(JdbcDatabase aStore) {
        this.store = aStore;
    }

    protected Connection getConnection() {
        return this.store.getConnection();
    }

    public int visitStatement(String statement) throws SQLException {
        mySQLLogger.info((Object)statement);
        if (this.getConnection() == null) {
            throw new JdbcException("cannot exec: " + statement + ", because 'not connected to database'");
        }
        Statement stmt = this.getConnection().createStatement();
        try {
            int n = stmt.executeUpdate(statement);
            return n;
        }
        catch (SQLException ex) {
            this.getConnection().rollback();
            throw ex;
        }
        finally {
            stmt.close();
        }
    }

    public void visitComment(String theComment) {
        this.log("Comment: " + theComment);
    }

    public void doCommit() throws SQLException {
        mySQLLogger.info((Object)"commit");
        if (this.getConnection() == null) {
            throw new JdbcException("cannot commit, because 'not connected to database'");
        }
        this.getConnection().commit();
    }

    public void doRollback() throws SQLException {
        mySQLLogger.info((Object)"rollback");
        if (this.getConnection() == null) {
            throw new JdbcException("cannot rollback, because 'not connected to database'");
        }
        this.getConnection().rollback();
    }

    public void log(Object obj) {
        if (obj instanceof Throwable) {
            myLogger.error(null, (Throwable)obj);
        } else {
            myLogger.info(obj);
        }
    }
}

