/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.checking;

import com.agimatec.dbtransform.DataType;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.sql.meta.CatalogDescription;
import com.agimatec.sql.meta.ColumnDescription;
import com.agimatec.sql.meta.ForeignKeyDescription;
import com.agimatec.sql.meta.IndexDescription;
import com.agimatec.sql.meta.SqlMetaFactory;
import com.agimatec.sql.meta.TableDescription;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcSqlMetaFactory
implements SqlMetaFactory {
    private final JdbcDatabase database;
    private boolean indices = true;
    private boolean primaryKeys = true;
    private boolean columns = true;
    private boolean foreignKeys = true;

    public JdbcSqlMetaFactory(JdbcDatabase database) {
        this.database = database;
    }

    public JdbcDatabase getDatabase() {
        return this.database;
    }

    public boolean isColumns() {
        return this.columns;
    }

    public void setColumns(boolean columns) {
        this.columns = columns;
    }

    public boolean isForeignKeys() {
        return this.foreignKeys;
    }

    public void setForeignKeys(boolean foreignKeys) {
        this.foreignKeys = foreignKeys;
    }

    public boolean isIndices() {
        return this.indices;
    }

    public void setIndices(boolean indices) {
        this.indices = indices;
    }

    public boolean isPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(boolean primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public void equalizeColumn(ColumnDescription cd) {
    }

    public CatalogDescription buildCatalog(String[] tables) throws SQLException, IOException {
        CatalogDescription catalog = new CatalogDescription();
        catalog.setSchemaName(this.getDatabase().getConnection().getCatalog());
        this.addTables(tables, catalog);
        return catalog;
    }

    protected void addTables(String[] tables, CatalogDescription aCatalog) throws SQLException, IOException {
        DatabaseMetaData meta = this.getDatabase().getConnection().getMetaData();
        Map<String, DataType> types = this.loadTypes(meta);
        for (String table : tables) {
            TableIdentifier tid = this.createTableIdentifier(table);
            ResultSet tableSet = meta.getTables(tid.getCat(), tid.getSchem(), tid.getTable(), new String[]{"TABLE"});
            while (tableSet.next()) {
                String cat = tableSet.getString("TABLE_CAT");
                tid.setCat(cat);
                String schem = tableSet.getString("TABLE_SCHEM");
                tid.setSchem(schem);
                TableDescription td = this.createTable(tableSet.getString("TABLE_NAME"));
                aCatalog.addTable(td);
                td.setComment(tableSet.getString("REMARKS"));
                if (this.primaryKeys) {
                    this.loadPrimaryKey(meta, tid, td);
                }
                if (this.columns) {
                    this.loadColumns(meta, types, tid, td);
                }
                if (this.foreignKeys) {
                    this.loadForeignKeys(meta, tid, td);
                }
                if (!this.indices) continue;
                this.loadIndexes(meta, tid, td);
            }
        }
    }

    protected TableIdentifier createTableIdentifier(String table) {
        return new TableIdentifier(table);
    }

    protected void loadIndexes(DatabaseMetaData meta, TableIdentifier tid, TableDescription td) throws SQLException {
        ResultSet indSet = meta.getIndexInfo(tid.getCat(), tid.getSchem(), tid.getTable(), false, true);
        IndexDescription id = null;
        while (indSet.next()) {
            String indName = indSet.getString("INDEX_NAME");
            if (id == null || id.getIndexName() != null && !id.getIndexName().equals(indName)) {
                id = new IndexDescription();
                id.setIndexName(indName);
                id.setUnique(!indSet.getBoolean("NON_UNIQUE"));
                id.setTableName(indSet.getString("TABLE_NAME"));
                if (td.getPrimaryKey() == null || !id.getIndexName().equals(td.getPrimaryKey().getIndexName())) {
                    td.addIndex(id);
                }
            }
            id.addColumn(indSet.getString("COLUMN_NAME"), "D".equals(indSet.getString("ASC_OR_DESC")) ? "DESC" : "ASC");
        }
    }

    protected void loadForeignKeys(DatabaseMetaData meta, TableIdentifier tid, TableDescription td) throws SQLException {
        ResultSet fkSet = meta.getImportedKeys(tid.getCat(), tid.getSchem(), tid.getTable());
        ForeignKeyDescription fkDesc = null;
        while (fkSet.next()) {
            String fkName = fkSet.getString("FK_NAME");
            if (fkDesc == null || fkDesc.getConstraintName() != null && !fkDesc.getConstraintName().equals(fkName)) {
                fkDesc = new ForeignKeyDescription();
                fkDesc.setTableName(fkSet.getString("FKTABLE_NAME"));
                fkDesc.setConstraintName(fkName);
                short i = fkSet.getShort("DELETE_RULE");
                switch (i) {
                    case 0: {
                        fkDesc.setOnDeleteRule("CASCADE");
                        break;
                    }
                    default: {
                        fkDesc.setOnDeleteRule(null);
                    }
                }
                fkDesc.setRefTableName(fkSet.getString("PKTABLE_NAME"));
                td.addForeignKey(fkDesc);
            }
            fkDesc.addColumnPair(fkSet.getString("FKCOLUMN_NAME"), fkSet.getString("PKCOLUMN_NAME"));
        }
    }

    protected Map<String, DataType> loadTypes(DatabaseMetaData meta) throws SQLException {
        HashMap<String, DataType> types = new HashMap<String, DataType>();
        ResultSet typeSet = meta.getTypeInfo();
        while (typeSet.next()) {
            DataType dt = new DataType();
            dt.setTypeName(typeSet.getString("TYPE_NAME"));
            dt.setPrecision(typeSet.getInt("PRECISION"));
            dt.setScale(new Integer(typeSet.getShort("MAXIMUM_SCALE")));
            dt.setPrecisionEnabled(dt.getPrecision() > 0);
            types.put(dt.getTypeName(), dt);
        }
        return types;
    }

    protected void loadColumns(DatabaseMetaData meta, Map<String, DataType> types, TableIdentifier tid, TableDescription td) throws SQLException {
        ResultSet colSet = meta.getColumns(tid.getCat(), tid.getSchem(), tid.getTable(), null);
        while (colSet.next()) {
            ColumnDescription cd = new ColumnDescription();
            cd.setColumnName(colSet.getString("COLUMN_NAME"));
            td.addColumn(cd);
            cd.setComment(colSet.getString("REMARKS"));
            cd.setTypeName(colSet.getString("TYPE_NAME"));
            DataType dt = types.get(cd.getTypeName());
            if (dt != null) {
                if (dt.isPrecisionEnabled() != null && dt.isPrecisionEnabled().booleanValue()) {
                    cd.setPrecision(colSet.getInt("COLUMN_SIZE"));
                }
                if (dt.getScale() != null && dt.getScale() != 0) {
                    cd.setScale(colSet.getInt("DECIMAL_DIGITS"));
                }
            }
            cd.setNullable(colSet.getInt("NULLABLE") == 1);
            cd.setDefaultValue(colSet.getString("COLUMN_DEF"));
            this.equalizeColumn(cd);
        }
    }

    protected void loadPrimaryKey(DatabaseMetaData meta, TableIdentifier tid, TableDescription td) throws SQLException {
        ResultSet colSet = meta.getPrimaryKeys(tid.getCat(), tid.getSchem(), tid.getTable());
        HashMap<Integer, String> pkColSeq = new HashMap<Integer, String>();
        if (colSet.next()) {
            IndexDescription pk = new IndexDescription();
            td.setPrimaryKey(pk);
            pk.setIndexName(colSet.getString("PK_NAME"));
            pk.setUnique(true);
            do {
                pkColSeq.put(colSet.getInt("KEY_SEQ"), colSet.getString("COLUMN_NAME"));
            } while (colSet.next());
            ArrayList keys = new ArrayList(pkColSeq.keySet());
            Collections.sort(keys);
            for (Integer seq : keys) {
                pk.addColumn((String)pkColSeq.get(seq));
            }
        }
    }

    protected TableDescription createTable(String tableName) throws SQLException {
        TableDescription tableDesc = new TableDescription();
        tableDesc.setTableName(tableName.toUpperCase());
        return tableDesc;
    }

    protected final class TableIdentifier {
        String cat;
        String schem;
        String table;

        public TableIdentifier(String table) {
            this.table = table;
        }

        public String getCat() {
            return this.cat;
        }

        public String getSchem() {
            return this.schem;
        }

        public String getTable() {
            return this.table;
        }

        public void setCat(String cat) {
            this.cat = cat;
        }

        public void setSchem(String schem) {
            this.schem = schem;
        }
    }
}

