/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.jdbc;

import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.jdbc.JdbcException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JdbcDatabaseImpl
implements JdbcDatabase {
    protected static final Log log = LogFactory.getLog(JdbcDatabaseImpl.class);
    private Connection connection;
    private final Properties properties = new Properties();
    private boolean transaction = false;

    public JdbcDatabaseImpl(Properties aProperties) {
        this.properties.putAll((Map<?, ?>)aProperties);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getDriverClassName() {
        return this.properties.getProperty("jdbcDriver");
    }

    public void begin() {
        if (this.isTransaction()) {
            throw new JdbcException("transaction already started");
        }
        if (this.connection == null) {
            this.connect();
        }
        this.transaction = true;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.transaction = connection != null;
    }

    private void connect() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("JdbcDriver: " + this.getDriverClassName() + "; JdbcConnect: " + this.getConnectionString() + "; properties: " + this.properties));
            }
            if (this.getDriverClassName() != null) {
                Class.forName(this.getDriverClassName());
            }
            this.connection = DriverManager.getConnection(this.getConnectionString(), this.properties);
        }
        catch (Exception e) {
            throw new JdbcException(e);
        }
    }

    public boolean isTransaction() {
        return this.connection != null && this.transaction;
    }

    public void rollback() {
        if (this.isTransaction()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
            finally {
                this.transaction = false;
            }
        } else {
            throw new JdbcException("cannot rollback - transaction not started");
        }
    }

    public void commit() {
        if (this.isTransaction()) {
            try {
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
            finally {
                this.transaction = false;
            }
        } else {
            throw new JdbcException("cannot commit - transaction not started");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectionString() {
        return this.properties.getProperty("jdbcUrl");
    }

    public void close() {
        if (this.connection != null) {
            Connection tc = this.connection;
            this.connection = null;
            try {
                tc.close();
            }
            catch (SQLException e) {
                throw new JdbcException(e);
            }
        }
    }

    public void init(String driver, String url, Properties props) {
        if (driver != null) {
            this.properties.setProperty("jdbcDriver", driver);
        }
        if (url != null) {
            this.properties.setProperty("jdbcUrl", url);
        }
        this.properties.putAll((Map<?, ?>)props);
    }
}

