/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.config;

import com.agimatec.commons.config.Config;
import com.agimatec.commons.config.FileNode;
import com.agimatec.commons.config.sax.ConfigContentHandler;
import com.agimatec.commons.config.sax.ConfigWriter;
import com.agimatec.commons.util.ClassUtils;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager
implements Serializable {
    private static final Log myLogger = LogFactory.getLog(ConfigManager.class);
    public static final String C_ProtocolClassPath = "cp://";
    protected static ConfigManager singleton = new ConfigManager("configmanager.ini");
    private static final String DEFAULT_CONFIGROOT_PATH = "file:";
    protected final String myConfigRootRessouceName;
    protected Config myConfigroot = null;
    protected String myConfigrootPath = null;
    protected Map myConfigMap = new Hashtable();

    public ConfigManager(String aConfigRootRessouceName) {
        this.myConfigRootRessouceName = aConfigRootRessouceName;
    }

    public static ConfigManager getDefault() {
        return singleton;
    }

    public Config readConfig(String aPath, boolean isRelativeFlag) {
        if (myLogger.isDebugEnabled()) {
            myLogger.debug((Object)("going to read config file (relative path): " + aPath));
        }
        if (isRelativeFlag) {
            aPath = this.makeAbsolutePath(aPath);
        }
        if (myLogger.isDebugEnabled()) {
            myLogger.debug((Object)("reading config file (path made absolute): " + aPath));
        }
        try {
            ConfigContentHandler theConfigHandler = new ConfigContentHandler(this);
            XMLReader theParser = this.createParser();
            theParser.setContentHandler(theConfigHandler);
            this.parseResource(theParser, aPath);
            return theConfigHandler.getConfig();
        }
        catch (Exception ex) {
            myLogger.error((Object)("cannot load xml configuration from " + aPath), (Throwable)ex);
            return null;
        }
    }

    public Config parseConfig(String aConfigXMLString) {
        try {
            ConfigContentHandler theConfigHandler = new ConfigContentHandler(this);
            XMLReader theParser = this.createParser();
            theParser.setContentHandler(theConfigHandler);
            this.parseString(theParser, aConfigXMLString);
            return theConfigHandler.getConfig();
        }
        catch (Exception ex) {
            myLogger.error(null, (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseString(XMLReader aParser, String aConfigXMLString) throws IOException, SAXException {
        StringReader reader = new StringReader(aConfigXMLString);
        try {
            aParser.parse(new InputSource(reader));
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseResource(XMLReader aParser, String aPath) throws IOException, SAXException {
        if (aPath.startsWith(C_ProtocolClassPath)) {
            String theResPath = aPath.substring(C_ProtocolClassPath.length());
            InputStream is = ClassUtils.getClassLoader().getResourceAsStream(theResPath);
            try {
                aParser.parse(new InputSource(is));
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        } else {
            aParser.parse(aPath);
        }
    }

    public static URL toURL(String path) throws MalformedURLException {
        if (path.startsWith(C_ProtocolClassPath)) {
            String theResPath = ConfigManager.resolvePath(path.substring(C_ProtocolClassPath.length()));
            return ClassUtils.getClassLoader().getResource(theResPath);
        }
        if (path.indexOf(58) < 0) {
            return new URL(DEFAULT_CONFIGROOT_PATH + path);
        }
        return new URL(path);
    }

    public static List<URL> toURLs(String path) throws IOException {
        if (path.startsWith(C_ProtocolClassPath)) {
            String theResPath = ConfigManager.resolvePath(path.substring(C_ProtocolClassPath.length()));
            Enumeration<URL> en = ClassUtils.getClassLoader().getResources(theResPath);
            ArrayList<URL> urls = new ArrayList<URL>();
            while (en.hasMoreElements()) {
                URL next = en.nextElement();
                urls.add(next);
            }
            return urls;
        }
        ArrayList<URL> urls = new ArrayList<URL>(1);
        urls.add(ConfigManager.toURL(path));
        return urls;
    }

    public static String resolvePath(String theResPath) {
        if (theResPath.contains("..")) {
            StringTokenizer tokens = new StringTokenizer(theResPath, "/", true);
            LinkedList<String> parts = new LinkedList<String>();
            boolean forward = false;
            while (tokens.hasMoreTokens()) {
                String part = tokens.nextToken();
                if (forward) {
                    forward = false;
                    if ("/".equals(part)) continue;
                }
                if ("..".equals(part)) {
                    if (parts.size() > 1 && "/".equals(parts.getLast())) {
                        parts.removeLast();
                        parts.removeLast();
                        forward = true;
                        continue;
                    }
                    parts.add(part);
                    continue;
                }
                parts.add(part);
            }
            StringBuilder buf = new StringBuilder();
            for (String part : parts) {
                buf.append(part);
            }
            theResPath = buf.toString();
            return theResPath;
        }
        return theResPath;
    }

    protected XMLReader createParser() {
        return new SAXParser();
    }

    public Config readConfig(String aPath) {
        return this.readConfig(aPath, true);
    }

    public void writeConfig(Config aConfig, PrintWriter aPrintWriter) throws IOException {
        try {
            new ConfigWriter().writeConfig(aConfig, aPrintWriter);
        }
        catch (SAXException saxEx) {
            myLogger.error(null, (Throwable)saxEx);
        }
    }

    public String writeConfig(Config aConfig) throws IOException {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.writeConfig(aConfig, pw);
            return sw.toString();
        }
        catch (Exception ex) {
            myLogger.error(null, (Throwable)ex);
            throw new RuntimeException(ex.toString());
        }
    }

    public Config getConfig(String aConfigname, String aPath) {
        return this.getConfig(aConfigname, aPath, true);
    }

    public Config getConfig(String aConfigName, String aPath, boolean isRelativeFlag) {
        Config theConfigRoot = this.getCachedConfig(aConfigName);
        if (theConfigRoot == null) {
            theConfigRoot = this.readConfig(aPath, isRelativeFlag);
            this.cacheConfig(theConfigRoot, aConfigName);
        }
        return theConfigRoot;
    }

    public Config getCachedConfig(String aConfigName) {
        return (Config)this.myConfigMap.get(aConfigName);
    }

    public Config getConfig(String configname) {
        return this.getConfig(configname, false);
    }

    public Config getConfigUncached(String configname) {
        FileNode theFileNode = (FileNode)this.getConfigRoot().getNode(configname);
        if (theFileNode == null) {
            throw new IllegalArgumentException(configname + " is an unknown config");
        }
        return this.readConfig(theFileNode.getURLPath(), false);
    }

    public Config getConfig(String configname, boolean allowNullReturn) {
        Config config = this.getCachedConfig(configname);
        if (config != null) {
            return config;
        }
        FileNode confNode = (FileNode)this.getConfigRoot().get(configname);
        if (confNode == null) {
            if (!allowNullReturn) {
                throw new IllegalArgumentException(configname + " is an unknown config");
            }
            return null;
        }
        config = this.readConfig(confNode.getURLPath(), false);
        if (config == null && allowNullReturn) {
            return null;
        }
        this.cacheConfig(config, configname);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Config getConfigRoot() {
        if (this.myConfigroot != null) return this.myConfigroot;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (this.myConfigroot != null) return this.myConfigroot;
            this.myConfigroot = this.getConfig("configroot", "configroot.xml");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.myConfigroot;
        }
    }

    public void cacheConfig(Config aConfig, String aConfigName) {
        if (aConfig != null) {
            aConfig.setName(aConfigName);
            this.myConfigMap.put(aConfigName, aConfig);
        }
    }

    public void uncacheConfig(Config aConfig) {
        this.myConfigMap.remove(aConfig.getName());
    }

    public void clearCache() {
        this.myConfigMap.clear();
    }

    private String makeAbsolutePath(String aRelativePath) {
        String theConfigRootPath = this.getConfigRootPath();
        StringBuilder strbuff = new StringBuilder(theConfigRootPath.length() + aRelativePath.length());
        strbuff.append(theConfigRootPath);
        strbuff.append(aRelativePath);
        return strbuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getConfigRootPath() {
        if (this.myConfigrootPath != null) return this.myConfigrootPath;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            if (this.myConfigrootPath != null) return this.myConfigrootPath;
            this.myConfigrootPath = this.readConfigrootPath();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.myConfigrootPath;
        }
    }

    public void setConfigRootPath(String aConfigRootPath) {
        this.myConfigrootPath = aConfigRootPath;
    }

    protected String readConfigrootPath() {
        return this.readConfigrootPath(this.myConfigRootRessouceName);
    }

    protected final String readConfigrootPath(String aResourceName) {
        String path = ConfigManager.readRessource(ConfigManager.class.getClassLoader(), aResourceName);
        return path == null ? DEFAULT_CONFIGROOT_PATH : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readRessource(ClassLoader aClassLoader, String aResourceName) {
        String string;
        URL theURL = aClassLoader.getResource(aResourceName);
        if (theURL == null) {
            String configRootProp;
            if (myLogger.isDebugEnabled()) {
                myLogger.debug((Object)("ConfigManager: " + aResourceName + " not found."));
            }
            if ((configRootProp = System.getProperty(aResourceName)) != null) {
                if (myLogger.isDebugEnabled()) {
                    myLogger.debug((Object)("Using System.property with value: " + configRootProp));
                }
                return configRootProp;
            }
            return null;
        }
        InputStream is = theURL.openStream();
        InputStreamReader isr = new InputStreamReader(is);
        try {
            char[] cbuf = new char[250];
            int len = isr.read(cbuf);
            StringBuilder buf = new StringBuilder(len);
            while (len > 0) {
                buf.append(cbuf, 0, len);
                len = isr.read(cbuf);
            }
            char c = buf.charAt(buf.length() - 1);
            if (myLogger.isDebugEnabled()) {
                myLogger.debug((Object)("resourcename: " + aResourceName + "\n  uncutted resourcepath: " + buf.toString()));
            }
            while (c == '\r' || c == '\n' || c == '\t' || c == ' ') {
                buf.deleteCharAt(buf.length() - 1);
                c = buf.charAt(buf.length() - 1);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                isr.close();
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            catch (IOException ioEx) {
                myLogger.error(null, (Throwable)ioEx);
                return null;
            }
        }
        isr.close();
        if (is != null) {
            is.close();
        }
        return string;
    }
}

