/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.query;

import com.agimatec.sql.SQLStatement;
import com.agimatec.sql.query.ArrayResultBuilder;
import com.agimatec.sql.query.JdbcResultBuilder;
import com.agimatec.sql.query.QueryDefinition;
import com.agimatec.sql.query.QueryResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcExecutor {
    protected static final Logger log = LoggerFactory.getLogger((String)"agimatec.sql.meta");

    protected QueryResult fetchResult(SQLStatement aQuery, JdbcResultBuilder resultBuilder, QueryDefinition queryDefinition) throws SQLException {
        int maxResults = queryDefinition.getMaxResults();
        ArrayList result = maxResults == 0 ? new ArrayList() : new ArrayList(maxResults);
        Connection connection = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            if (log.isInfoEnabled()) {
                log.info(aQuery.getParameterizedStatement());
            }
            stmt = aQuery.getPreparedStatement().asPreparedStatement(connection);
            resultSet = stmt.executeQuery();
            resultBuilder.afterExecute(resultSet.getMetaData(), queryDefinition.getQueryObject(), result);
            boolean hasnext = resultSet.next();
            while ((maxResults == 0 || result.size() < maxResults) && hasnext) {
                resultBuilder.fetch(resultSet);
                hasnext = resultSet.next();
            }
            resultBuilder.close(!hasnext);
            QueryResult queryResult = new QueryResult(result, !hasnext);
            return queryResult;
        }
        catch (SQLException ex) {
            if (log.isErrorEnabled()) {
                log.error("Error executing SQL: " + aQuery.getParameterizedStatement(), (Throwable)ex);
            }
            throw ex;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected int execRowsAffected(SQLStatement aSQL) throws SQLException {
        int result;
        Connection connection = this.getConnection();
        if (log.isInfoEnabled()) {
            log.info(aSQL.getParameterizedStatement());
        }
        PreparedStatement stmt = aSQL.getPreparedStatement().asPreparedStatement(connection);
        try {
            result = stmt.executeUpdate();
        }
        catch (SQLException ex) {
            if (log.isErrorEnabled()) {
                log.error("Error executing SQL: " + aSQL.getParameterizedStatement(), (Throwable)ex);
            }
            throw ex;
        }
        finally {
            stmt.close();
        }
        return result;
    }

    protected JdbcResultBuilder newResultVisitor(String className) {
        if (className == null) {
            return new ArrayResultBuilder();
        }
        try {
            return (JdbcResultBuilder)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            log.error(null, (Throwable)ex);
            return null;
        }
    }

    public abstract Connection getConnection();
}

