/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.dbmigrate.util;

import com.agimatec.dbmigrate.util.DBVersionMeta;
import com.agimatec.dbmigrate.util.ScriptVisitorDelegate;
import com.agimatec.jdbc.JdbcDatabase;
import com.agimatec.sql.script.ScriptVisitor;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateVersionScriptVisitor
extends ScriptVisitorDelegate {
    private static final Logger log = LoggerFactory.getLogger(UpdateVersionScriptVisitor.class);
    private final JdbcDatabase jdbcStore;
    private final DBVersionMeta meta;

    public UpdateVersionScriptVisitor(JdbcDatabase aStore, ScriptVisitor aVisitor, DBVersionMeta meta) {
        super(aVisitor);
        this.jdbcStore = aStore;
        this.meta = meta == null ? new DBVersionMeta() : meta;
    }

    public void visitComment(String theComment) throws SQLException {
        super.visitComment(theComment);
        int idx = theComment.indexOf("@version");
        if (idx < 0) {
            idx = theComment.indexOf("#version");
        }
        if (idx >= 0) {
            StringTokenizer tokens = new StringTokenizer(theComment.substring(idx + "#version".length()), "()");
            String dbVersion = null;
            if (tokens.hasMoreTokens()) {
                dbVersion = tokens.nextToken();
            }
            if (dbVersion == null) {
                log.warn("cannot find a version in " + theComment);
            } else {
                UpdateVersionScriptVisitor.updateVersionInDatabase(this.jdbcStore, dbVersion, this.meta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVersionInDatabase(JdbcDatabase jdbcStore, String dbVersion, DBVersionMeta meta) throws SQLException {
        log.info("*** update version to: " + dbVersion);
        if (jdbcStore.getConnection() == null) {
            throw new SQLException("not connected to database");
        }
        int count = 0;
        boolean canAccessDbVersionTable = true;
        if (!meta.isInsertOnly()) {
            PreparedStatement s = jdbcStore.getConnection().prepareStatement(meta.toSQLUpdate());
            try {
                UpdateVersionScriptVisitor.setParameters(s, dbVersion, meta);
                count = s.executeUpdate();
            }
            catch (SQLException ex) {
                log.warn("cannot update " + meta.getQualifiedVersionColumn() + " = " + dbVersion + " because " + ex.getMessage());
                canAccessDbVersionTable = UpdateVersionScriptVisitor.createTable(jdbcStore, meta);
                if (!canAccessDbVersionTable) {
                    log.info("autoCreate=false, create table " + meta.getTableName() + " to persist the database version: " + dbVersion);
                }
            }
            finally {
                s.close();
            }
        }
        if (count == 0 && canAccessDbVersionTable) {
            UpdateVersionScriptVisitor.insertVersion(jdbcStore, dbVersion, meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertVersion(JdbcDatabase jdbcStore, String dbVersion, DBVersionMeta meta) throws SQLException {
        PreparedStatement s = jdbcStore.getConnection().prepareStatement(meta.toSQLInsert());
        try {
            UpdateVersionScriptVisitor.setParameters(s, dbVersion, meta);
            int n = s.executeUpdate();
            return n;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteVersion(JdbcDatabase jdbcStore, String dbVersion, DBVersionMeta meta) throws SQLException {
        PreparedStatement s = jdbcStore.getConnection().prepareStatement(meta.toSQLDelete());
        try {
            s.setString(1, dbVersion);
            int n = s.executeUpdate();
            return n;
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTable(JdbcDatabase jdbcStore, DBVersionMeta meta) throws SQLException {
        if (!meta.isAutoCreate()) {
            return false;
        }
        Statement stmt = jdbcStore.getConnection().createStatement();
        try {
            stmt.execute(meta.toSQLCreateTable());
            log.info("autoCreate=true, created table " + meta.getTableName());
        }
        finally {
            stmt.close();
        }
        return true;
    }

    private static void setParameters(PreparedStatement s, String dbVersion, DBVersionMeta meta) throws SQLException {
        s.setString(1, dbVersion);
        if (StringUtils.isNotEmpty((String)meta.getColumn_since())) {
            s.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        }
    }
}

