/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<String> readLines(URL url) throws IOException {
        return ResourceUtils.readLines(ResourceUtils.newReader(url));
    }

    public static List<String> readLines(BufferedReader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ResourceUtils.eachLine(reader, lines);
        return lines;
    }

    private static BufferedReader newReader(URL url) throws IOException {
        return ResourceUtils.newReader(url.openConnection().getInputStream());
    }

    private static BufferedReader newReader(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void eachLine(BufferedReader br, List<String> lines) throws IOException {
        try {
            String line;
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            br.close();
        }
    }

    public static Collection<String> getResources(String resourceDir) throws IOException {
        Enumeration<URL> enums = Thread.currentThread().getContextClassLoader().getResources(resourceDir);
        HashSet<String> all = new HashSet<String>();
        while (enums.hasMoreElements()) {
            URL url = enums.nextElement();
            all.addAll(ResourceUtils.getURLResources(url));
        }
        return all;
    }

    public static Collection<String> getURLResources(URL dirURL) throws IOException {
        if (dirURL.getProtocol().equals("file")) {
            try {
                return Arrays.asList(new File(URLDecoder.decode(dirURL.getPath(), "UTF-8")).list());
            }
            catch (Exception ignore) {
                try {
                    return Arrays.asList(new File(dirURL.getPath()).list());
                }
                catch (Exception ex) {
                    throw new IOException("Cannot list directory " + dirURL.getPath(), ex);
                }
            }
        }
        if (dirURL.getProtocol().equals("jar")) {
            JarFile jar;
            String urlPath = dirURL.getPath();
            int idx2 = urlPath.indexOf("!");
            String jarPath = urlPath.substring(5, idx2);
            String resourceDir = urlPath.substring(idx2 + 2, urlPath.length());
            if (!resourceDir.endsWith("/")) {
                resourceDir = resourceDir + "/";
            }
            try {
                jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            }
            catch (Exception ignore) {
                try {
                    jar = new JarFile(jarPath);
                }
                catch (Exception ex) {
                    throw new IOException("Cannot open jar " + jarPath + " in " + dirURL, ex);
                }
            }
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (name.length() <= resourceDir.length() || !name.startsWith(resourceDir)) continue;
                result.add(new File(name).getName());
            }
            return result;
        }
        return ResourceUtils.readLines(dirURL);
    }
}

