/*
 * Decompiled with CFR 0.152.
 */
package com.agimatec.sql.meta.script;

import com.agimatec.sql.meta.script.A_ExtractPart;
import com.agimatec.sql.meta.script.PropertiesExtractor;

class ExtractProperty
extends A_ExtractPart {
    private String startDelimeter;
    private String endDelimeter;
    private final String name;
    private boolean optional;
    private String word;

    public ExtractProperty(String aName) {
        this.name = aName;
    }

    public ExtractProperty(String aProp, String aWord, boolean isOptional) {
        this.name = aProp;
        this.word = aWord;
        this.optional = isOptional;
    }

    public void setStartDelimeter(String startDelimeter) {
        this.startDelimeter = startDelimeter;
    }

    public void setEndDelimeter(String endDelimeter) {
        this.endDelimeter = endDelimeter;
    }

    public int fits(String aToken) {
        return this.optional ? 3 : 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.optional) {
            buf.append('[');
        }
        buf.append("${");
        buf.append(this.name);
        if (this.word != null) {
            buf.append("(");
            buf.append(this.word);
            buf.append(")");
        }
        if (this.startDelimeter != null) {
            buf.append('{').append(this.startDelimeter).append('}');
            if (this.endDelimeter != null && !this.endDelimeter.equals(this.startDelimeter)) {
                buf.append('{').append(this.endDelimeter).append('}');
            }
        }
        buf.append('}');
        if (this.optional) {
            buf.append(']');
        }
        return buf.toString();
    }

    public int process(String aToken, PropertiesExtractor extractor) {
        if (this.word == null) {
            if (this.startDelimeter == null) {
                this.setValue(extractor, aToken);
                return 1;
            }
            if (aToken.startsWith(this.startDelimeter)) {
                if (aToken.length() > this.startDelimeter.length() && aToken.endsWith(this.endDelimeter)) {
                    this.setValue(extractor, aToken.substring(this.startDelimeter.length(), aToken.length() - this.endDelimeter.length()));
                    return 1;
                }
                return 2;
            }
        } else {
            boolean needsMore = false;
            boolean error = false;
            if (this.startDelimeter != null) {
                if (aToken.startsWith(this.startDelimeter)) {
                    if (aToken.endsWith(this.endDelimeter)) {
                        aToken = aToken.substring(this.startDelimeter.length(), aToken.length() - this.endDelimeter.length());
                    } else {
                        aToken = aToken.substring(this.startDelimeter.length());
                        needsMore = true;
                    }
                } else {
                    error = true;
                }
            }
            if (!error) {
                if (!needsMore && aToken.equalsIgnoreCase(this.word)) {
                    this.setValue(extractor, aToken);
                    return 1;
                }
                if (this.word.toUpperCase().startsWith(aToken.toUpperCase())) {
                    return 2;
                }
            }
        }
        return this.optional ? 3 : 0;
    }

    private void setValue(PropertiesExtractor extractor, String aToken) {
        extractor.current.put(this.name, aToken);
    }

    protected boolean isOptional() {
        return this.optional;
    }
}

